/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.EventBusMessage;
import org.springframework.beans.factory.annotation.Autowired;

public final class RegistrationHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    @Autowired
    public RegistrationHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    protected String getEventBusAddress() {
        return "registration.in";
    }

    @Override
    public String getName() {
        return "registration";
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenant = String.format("/%s/:%s", "registration", "tenant_id");
        router.route(HttpMethod.POST, pathWithTenant).consumes("application/json").handler(this::doRegisterDeviceJson);
        router.route(HttpMethod.POST, pathWithTenant).handler(ctx -> HttpUtils.badRequest(ctx, "missing or unsupported content-type"));
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", "registration", "tenant_id", "device_id");
        router.route(HttpMethod.GET, pathWithTenantAndDeviceId).handler(this::doGetDevice);
        router.route(HttpMethod.PUT, pathWithTenantAndDeviceId).consumes("application/json").handler(this::doUpdateRegistrationJson);
        router.route(HttpMethod.PUT, pathWithTenantAndDeviceId).handler(ctx -> HttpUtils.badRequest(ctx, "missing or unsupported content-type"));
        router.route(HttpMethod.DELETE, pathWithTenantAndDeviceId).handler(this::doUnregisterDevice);
    }

    private void doGetDevice(RoutingContext ctx) {
        String deviceId = this.getDeviceIdParam(ctx);
        String tenantId = this.getTenantParam(ctx);
        HttpServerResponse response = ctx.response();
        JsonObject requestMsg = EventBusMessage.forOperation((String)"get").setTenant(tenantId).setDeviceId(deviceId).toJson();
        this.sendAction(ctx, requestMsg, (status, registrationResult) -> {
            response.setStatusCode(status.intValue());
            switch (status) {
                case 200: {
                    HttpUtils.setResponseBody(ctx.response(), registrationResult);
                }
            }
            response.end();
        });
    }

    private void doRegisterDeviceJson(RoutingContext ctx) {
        try {
            JsonObject payload = null;
            if (ctx.getBody().length() > 0) {
                payload = ctx.getBodyAsJson();
            }
            this.registerDevice(ctx, payload);
        }
        catch (DecodeException e) {
            HttpUtils.badRequest(ctx, "body does not contain a valid JSON object");
        }
    }

    private void registerDevice(RoutingContext ctx, JsonObject payload) {
        if (payload == null) {
            HttpUtils.badRequest(ctx, "missing body");
        } else {
            Object deviceId = payload.remove("device-id");
            if (deviceId == null) {
                HttpUtils.badRequest(ctx, String.format("'%s' param is required", "device-id"));
            } else if (!(deviceId instanceof String)) {
                HttpUtils.badRequest(ctx, String.format("'%s' must be a string", "device-id"));
            } else {
                String tenantId = this.getTenantParam(ctx);
                this.logger.debug("registering data for device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
                JsonObject requestMsg = EventBusMessage.forOperation((String)"register").setTenant(tenantId).setDeviceId((String)deviceId).setJsonPayload(payload).toJson();
                this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, status -> status == 201, (Handler<HttpServerResponse>)((Handler)response -> response.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s/%s", "registration", tenantId, deviceId)))));
            }
        }
    }

    private void doUpdateRegistrationJson(RoutingContext ctx) {
        try {
            JsonObject payload = null;
            if (ctx.getBody().length() > 0) {
                payload = ctx.getBodyAsJson();
            }
            this.updateRegistration(this.getDeviceIdParam(ctx), payload, ctx);
        }
        catch (DecodeException e) {
            HttpUtils.badRequest(ctx, "body does not contain a valid JSON object");
        }
    }

    private void updateRegistration(String deviceId, JsonObject payload, RoutingContext ctx) {
        if (payload != null) {
            payload.remove("device-id");
        }
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("updating registration data for device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
        JsonObject requestMsg = EventBusMessage.forOperation((String)"update").setTenant(tenantId).setDeviceId(deviceId).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx));
    }

    private void doUnregisterDevice(RoutingContext ctx) {
        String deviceId = this.getDeviceIdParam(ctx);
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("removing registration information for device [tenant: {}, device: {}]", (Object)tenantId, (Object)deviceId);
        JsonObject requestMsg = EventBusMessage.forOperation((String)"deregister").setTenant(tenantId).setDeviceId(deviceId).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx));
    }
}

