/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsObject;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.EventBusMessage;

public abstract class BaseCredentialsService<T>
extends EventBusService<T>
implements CredentialsService {
    @Override
    protected String getEventBusAddress() {
        return "credentials.in";
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        String operation = request.getOperation();
        switch (CredentialsConstants.CredentialsAction.from((String)operation)) {
            case get: {
                return this.processGetRequest(request);
            }
            case add: {
                return this.processAddRequest(request);
            }
            case update: {
                return this.processUpdateRequest(request);
            }
            case remove: {
                return this.processRemoveRequest(request);
            }
        }
        return this.processCustomCredentialsMessage(request);
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        String type = (String)this.removeTypesafeValueForField(payload, "type");
        String authId = (String)this.removeTypesafeValueForField(payload, "auth-id");
        String deviceId = (String)this.removeTypesafeValueForField(payload, "device-id");
        if (type == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (authId != null && deviceId == null) {
            this.log.debug("getting credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            Future result = Future.future();
            this.get(tenantId, type, authId, payload, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> {
                String deviceIdFromPayload = Optional.ofNullable(res.getPayload()).map(p -> (String)this.getTypesafeValueForField((JsonObject)p, "device-id")).orElse(null);
                return request.getResponse(res.getStatus()).setDeviceId(deviceIdFromPayload).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective());
            });
        }
        if (deviceId != null && authId == null) {
            this.log.debug("getting credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            Future result = Future.future();
            this.getAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        this.log.debug("get credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processAddRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        CredentialsObject payload = Optional.ofNullable(request.getJsonPayload()).map(json -> (CredentialsObject)json.mapTo(CredentialsObject.class)).orElse(null);
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (payload.isValid()) {
            Future result = Future.future();
            this.add(tenantId, JsonObject.mapFrom((Object)payload), (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(payload.getDeviceId()).setCacheDirective(res.getCacheDirective()));
        }
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        CredentialsObject payload = Optional.ofNullable(request.getJsonPayload()).map(json -> (CredentialsObject)json.mapTo(CredentialsObject.class)).orElse(null);
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (payload.isValid()) {
            Future result = Future.future();
            this.update(tenantId, JsonObject.mapFrom((Object)payload), (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(payload.getDeviceId()).setCacheDirective(res.getCacheDirective()));
        }
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processRemoveRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        String type = (String)this.getTypesafeValueForField(payload, "type");
        String authId = (String)this.getTypesafeValueForField(payload, "auth-id");
        String deviceId = (String)this.getTypesafeValueForField(payload, "device-id");
        if (type == null) {
            this.log.debug("remove credentials request does not contain mandatory type parameter");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (!type.equals("*") && authId != null) {
            this.log.debug("removing specific credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            Future result = Future.future();
            this.remove(tenantId, type, authId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setCacheDirective(res.getCacheDirective()));
        }
        if (deviceId != null && type.equals("*")) {
            this.log.debug("removing all credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            Future result = Future.future();
            this.removeAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
        }
        this.log.debug("remove credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    protected Future<EventBusMessage> processCustomCredentialsMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public void add(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void get(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void get(String tenantId, String type, String authId, JsonObject clientContext, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void getAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)CredentialsResult.from((int)501)));
    }
}

