/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonSender;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.client.impl.AbstractSender;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.service.command.CommandResponseSender;
import org.eclipse.hono.util.MessageHelper;

public class CommandResponseSenderImpl
extends AbstractSender
implements CommandResponseSender {
    CommandResponseSenderImpl(ClientConfigProperties config, ProtonSender sender, String tenantId, String targetAddress, Context context) {
        super(config, sender, tenantId, targetAddress, context);
    }

    protected Future<ProtonDelivery> sendMessage(Message message) {
        return this.sendMessageAndWaitForOutcome(message);
    }

    protected String getTo(String deviceId) {
        return null;
    }

    public String getEndpoint() {
        return "control";
    }

    public Future<ProtonDelivery> sendAndWaitForOutcome(Message message) {
        return this.sendMessageAndWaitForOutcome(message);
    }

    static final String getTargetAddress(String tenantId, String deviceId, String replyId) {
        return String.format("%s/%s/%s/%s", "control", tenantId, deviceId, replyId);
    }

    @Override
    public Future<ProtonDelivery> sendCommandResponse(String correlationId, Buffer payload, Map<String, Object> properties, int status) {
        this.LOG.debug("send back a command response [correlationId: {}, status: {}]", (Object)correlationId, (Object)status);
        return this.sendAndWaitForOutcome(CommandResponseSenderImpl.createResponseMessage(this.targetAddress, correlationId, payload, properties, status));
    }

    private static Message createResponseMessage(String targetAddress, String correlationId, Buffer payload, Map<String, Object> properties, int status) {
        Objects.requireNonNull(targetAddress);
        Objects.requireNonNull(correlationId);
        Message msg = ProtonHelper.message();
        msg.setCorrelationId((Object)correlationId);
        msg.setAddress(targetAddress);
        if (payload != null) {
            msg.setBody((Section)new Data(new Binary(payload.getBytes())));
        }
        if (properties != null) {
            msg.setApplicationProperties(new ApplicationProperties(properties));
        }
        MessageHelper.setCreationTime((Message)msg);
        MessageHelper.addProperty((Message)msg, (String)"status", (Object)status);
        return msg;
    }

    public static void create(Context context, ClientConfigProperties clientConfig, ProtonConnection con, String tenantId, String deviceId, String replyId, Handler<String> closeHook, Handler<AsyncResult<MessageSender>> creationHandler) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(clientConfig);
        Objects.requireNonNull(con);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(replyId);
        String targetAddress = CommandResponseSenderImpl.getTargetAddress(tenantId, deviceId, replyId);
        CommandResponseSenderImpl.createSender((Context)context, (ClientConfigProperties)clientConfig, (ProtonConnection)con, (String)targetAddress, (ProtonQoS)ProtonQoS.AT_LEAST_ONCE, closeHook).compose(sender -> Future.succeededFuture((Object)new CommandResponseSenderImpl(clientConfig, (ProtonSender)sender, tenantId, targetAddress, context))).setHandler(creationHandler);
    }
}

