/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.impl.AbstractConsumer;
import org.eclipse.hono.client.impl.AbstractHonoClient;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandConsumer
extends AbstractConsumer
implements MessageConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CommandConsumer.class);

    private CommandConsumer(Context context, ClientConfigProperties config, ProtonReceiver protonReceiver) {
        super(context, config, protonReceiver);
    }

    public static final void create(Context context, ClientConfigProperties clientConfig, ProtonConnection con, String tenantId, String deviceId, BiConsumer<ProtonDelivery, Message> messageConsumer, Handler<String> receiverCloseHook, Handler<AsyncResult<MessageConsumer>> creationHandler) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(clientConfig);
        Objects.requireNonNull(con);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(messageConsumer);
        Objects.requireNonNull(receiverCloseHook);
        Objects.requireNonNull(creationHandler);
        LOG.debug("creating new command consumer for [{}, {}]", (Object)tenantId, (Object)deviceId);
        String address = ResourceIdentifier.from((String)"control", (String)tenantId, (String)deviceId).toString();
        AbstractHonoClient.createReceiver((Context)context, (ClientConfigProperties)clientConfig, (ProtonConnection)con, (String)address, (ProtonQoS)ProtonQoS.AT_LEAST_ONCE, messageConsumer::accept, receiverCloseHook).setHandler(s -> {
            if (s.succeeded()) {
                LOG.debug("successfully created command consumer for [{}, {}]", (Object)tenantId, (Object)deviceId);
                creationHandler.handle((Object)Future.succeededFuture((Object)((Object)new CommandConsumer(context, clientConfig, (ProtonReceiver)s.result()))));
            } else {
                LOG.debug("failed to create command consumer for [{}, {}]", new Object[]{tenantId, deviceId, s.cause()});
                creationHandler.handle((Object)Future.failedFuture((Throwable)s.cause()));
            }
        });
    }
}

