/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.AbstractDeviceCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordCredentials
extends AbstractDeviceCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordCredentials.class);
    private String password;

    private UsernamePasswordCredentials(String tenantId, String authId) {
        super(tenantId, authId);
    }

    public static final UsernamePasswordCredentials create(String username, String password, boolean singleTenant) {
        UsernamePasswordCredentials credentials;
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        if (singleTenant) {
            credentials = new UsernamePasswordCredentials("DEFAULT_TENANT", username);
        } else {
            String[] userComponents = username.split("@", 2);
            if (userComponents.length != 2) {
                LOG.trace("username does not comply with expected pattern [<authId>@<tenantId>]", (Object)username);
                return null;
            }
            credentials = new UsernamePasswordCredentials(userComponents[1], userComponents[0]);
        }
        credentials.password = password;
        return credentials;
    }

    @Override
    public final String getType() {
        return "hashed-password";
    }

    public final String getPassword() {
        return this.password;
    }

    @Override
    public boolean matchesCredentials(JsonObject candidateSecret) {
        try {
            String pwdHash = candidateSecret.getString("pwd-hash");
            if (pwdHash == null) {
                LOG.debug("candidate hashed-password secret does not contain a pwd hash");
                return false;
            }
            byte[] hashedPasswordOnRecord = Base64.getDecoder().decode(pwdHash);
            byte[] salt = null;
            String encodedSalt = candidateSecret.getString("salt");
            if (encodedSalt != null) {
                salt = Base64.getDecoder().decode(encodedSalt);
            }
            String hashFunction = candidateSecret.getString("hash-function", "sha-256");
            return this.checkPassword(hashFunction, salt, hashedPasswordOnRecord);
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cannot decode malformed Base64 encoded property", (Throwable)e);
            }
            return false;
        }
        catch (ClassCastException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cannot process malformed candidate hashed-password secret returned by Credentials service [{}]", (Object)candidateSecret.encodePrettily());
            }
            return false;
        }
    }

    private boolean checkPassword(String hashFunction, byte[] salt, byte[] hashedPasswordOnRecord) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashFunction);
            if (salt != null) {
                messageDigest.update(salt);
            }
            byte[] hashedPassword = messageDigest.digest(this.getPassword().getBytes(StandardCharsets.UTF_8));
            return Arrays.equals(hashedPassword, hashedPasswordOnRecord);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }
}

