/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.util.CredentialsObject;

public abstract class AbstractDeviceCredentials
implements DeviceCredentials {
    private final String tenantId;
    private final String authId;

    protected AbstractDeviceCredentials(String tenantId, String authId) {
        this.tenantId = tenantId;
        this.authId = authId;
    }

    @Override
    public final String getAuthId() {
        return this.authId;
    }

    @Override
    public final String getTenantId() {
        return this.tenantId;
    }

    @Override
    public final boolean validate(CredentialsObject credentialsOnRecord) {
        Objects.requireNonNull(credentialsOnRecord);
        if (!this.getAuthId().equals(credentialsOnRecord.getAuthId())) {
            return false;
        }
        if (!this.getType().equals(credentialsOnRecord.getType())) {
            return false;
        }
        if (!credentialsOnRecord.isEnabled()) {
            return false;
        }
        JsonArray secrets = credentialsOnRecord.getSecrets();
        if (secrets == null) {
            throw new IllegalArgumentException("credentials do not contain any secret");
        }
        return this.validate(secrets);
    }

    private boolean validate(JsonArray secretsOnRecord) {
        return secretsOnRecord.stream().filter(obj -> obj instanceof JsonObject).anyMatch(obj -> {
            JsonObject candidateSecret = (JsonObject)obj;
            return this.isInValidityPeriod(candidateSecret, Instant.now()) && this.matchesCredentials(candidateSecret);
        });
    }

    private boolean isInValidityPeriod(JsonObject secret, Instant instant) {
        Instant notBefore = CredentialsObject.getNotBefore((JsonObject)secret);
        Instant notAfter = CredentialsObject.getNotAfter((JsonObject)secret);
        return !(notBefore != null && !instant.isAfter(notBefore) || notAfter != null && !instant.isBefore(notAfter));
    }

    public abstract boolean matchesCredentials(JsonObject var1);
}

