/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Future;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.net.ssl.X509TrustManager;
import org.eclipse.hono.client.HonoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantApiBasedX509TrustManager
implements X509TrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(TenantApiBasedX509TrustManager.class);
    private final HonoClient client;

    public TenantApiBasedX509TrustManager(HonoClient client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Objects.requireNonNull(chain);
        X509Certificate deviceCertificate = chain[0];
        CompletableFuture tenantRequest = new CompletableFuture();
        LOG.debug("validating client certificate [issuer: {}]", (Object)deviceCertificate.getIssuerX500Principal().getName("RFC2253"));
        this.client.isConnected().compose(ok -> this.client.getOrCreateTenantClient()).compose(tenantClient -> tenantClient.get(deviceCertificate.getIssuerX500Principal())).compose(tenant -> {
            if (!tenant.isEnabled()) {
                LOG.debug("device belongs to disabled tenant");
            }
            if (tenant.getTrustAnchor() == null) {
                return Future.failedFuture((Throwable)new IllegalStateException(String.format("no trust anchor configured for tenant [%s]", tenant.getTenantId())));
            }
            return this.checkCertPath(deviceCertificate, tenant.getTrustAnchor());
        }).setHandler(validation -> {
            if (validation.succeeded()) {
                tenantRequest.complete(null);
            } else {
                tenantRequest.completeExceptionally(validation.cause());
            }
        });
        try {
            tenantRequest.join();
        }
        catch (CompletionException e) {
            LOG.debug("validation of device certificate failed: {}", (Object)e.getCause().getMessage());
            throw new CertificateException("validation of device certificate failed", e.getCause());
        }
    }

    private Future<Void> checkCertPath(X509Certificate deviceCertificate, TrustAnchor trustAnchor) {
        Future result = Future.future();
        try {
            PKIXParameters params = new PKIXParameters(Collections.singleton(trustAnchor));
            params.setRevocationEnabled(false);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            CertPath certPath = factory.generateCertPath(Collections.singletonList(deviceCertificate));
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(certPath, params);
            LOG.debug("validation of device certificate [subject DN: {}] succeeded", (Object)deviceCertificate.getSubjectX500Principal().getName());
            result.complete();
        }
        catch (GeneralSecurityException e) {
            LOG.debug("validation of device certificate [subject DN: {}] failed", (Object)deviceCertificate.getSubjectX500Principal().getName(), (Object)e);
            result.fail((Throwable)e);
        }
        return result;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

