/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import javax.security.auth.login.CredentialException;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.service.auth.BaseAuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHonoAuthenticationService<T>
extends BaseAuthenticationService<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void authenticate(JsonObject authRequest, Handler<AsyncResult<HonoUser>> resultHandler) {
        String mechanism = Objects.requireNonNull(authRequest).getString("mechanism");
        this.log.debug("received authentication request [mechanism: {}]", (Object)mechanism);
        if ("PLAIN".equals(mechanism)) {
            byte[] saslResponse = authRequest.getBinary("sasl-response", new byte[0]);
            try {
                String[] fields = this.readFields(saslResponse);
                String authzid = fields[0];
                String authcid = fields[1];
                String pwd = fields[2];
                this.log.debug("processing PLAIN authentication request [authzid: {}, authcid: {}, pwd: *****]", (Object)authzid, (Object)authcid);
                this.verifyPlain(authzid, authcid, pwd, resultHandler);
            }
            catch (CredentialException e) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)e));
            }
        } else if ("EXTERNAL".equals(mechanism)) {
            String authzid = new String(authRequest.getBinary("sasl-response"), StandardCharsets.UTF_8);
            String subject = authRequest.getString("subject-dn");
            this.log.debug("processing EXTERNAL authentication request [Subject DN: {}]", (Object)subject);
            this.verifyExternal(authzid, subject, resultHandler);
        } else {
            resultHandler.handle((Object)Future.failedFuture((String)"unsupported SASL mechanism"));
        }
    }

    private String[] readFields(byte[] buffer) throws CredentialException {
        ArrayList<String> fields = new ArrayList<String>();
        Buffer b = Buffer.buffer();
        for (int pos = 0; pos < buffer.length; ++pos) {
            byte val = buffer[pos];
            if (val == 0) {
                fields.add(b.toString(StandardCharsets.UTF_8));
                b = Buffer.buffer();
                continue;
            }
            b.appendByte(val);
        }
        fields.add(b.toString(StandardCharsets.UTF_8));
        if (fields.size() != 3) {
            throw new CredentialException("client provided malformed PLAIN response");
        }
        if (fields.get(1) == null || ((String)fields.get(1)).length() == 0) {
            throw new CredentialException("PLAIN response must contain an authentication ID");
        }
        if (fields.get(2) == null || ((String)fields.get(2)).length() == 0) {
            throw new CredentialException("PLAIN response must contain a password");
        }
        return fields.toArray(new String[3]);
    }

    public abstract void verifyPlain(String var1, String var2, String var3, Handler<AsyncResult<HonoUser>> var4);

    public abstract void verifyExternal(String var1, String var2, Handler<AsyncResult<HonoUser>> var3);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

