/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.RegistrationConstants;
import org.springframework.beans.factory.annotation.Autowired;

public final class RegistrationHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    private static final String PARAM_TENANT_ID = "tenant_id";
    private static final String PARAM_DEVICE_ID = "device_id";

    @Autowired
    public RegistrationHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public String getName() {
        return "registration";
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenant = String.format("/%s/:%s", "registration", PARAM_TENANT_ID);
        router.route(HttpMethod.POST, pathWithTenant).consumes("application/json").handler(this::doRegisterDeviceJson);
        router.route(HttpMethod.POST, pathWithTenant).handler(ctx -> HttpUtils.badRequest(ctx, "missing or unsupported content-type"));
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", "registration", PARAM_TENANT_ID, PARAM_DEVICE_ID);
        router.route(HttpMethod.GET, pathWithTenantAndDeviceId).handler(this::doGetDevice);
        router.route(HttpMethod.PUT, pathWithTenantAndDeviceId).consumes("application/json").handler(this::doUpdateRegistrationJson);
        router.route(HttpMethod.PUT, pathWithTenantAndDeviceId).handler(ctx -> HttpUtils.badRequest(ctx, "missing or unsupported content-type"));
        router.route(HttpMethod.DELETE, pathWithTenantAndDeviceId).handler(this::doUnregisterDevice);
    }

    private static String getTenantParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TENANT_ID);
    }

    private static String getDeviceIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_DEVICE_ID);
    }

    private static void setResponseBody(JsonObject registrationResult, HttpServerResponse response) {
        JsonObject msg = registrationResult.getJsonObject("payload");
        if (msg != null) {
            String body = msg.encodePrettily();
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(body.length())).write(body);
        }
    }

    private void doGetDevice(RoutingContext ctx) {
        String deviceId = RegistrationHttpEndpoint.getDeviceIdParam(ctx);
        String tenantId = RegistrationHttpEndpoint.getTenantParam(ctx);
        HttpServerResponse response = ctx.response();
        JsonObject requestMsg = RegistrationConstants.getServiceRequestAsJson((String)"get", (String)tenantId, (String)deviceId);
        this.doRegistrationAction(ctx, requestMsg, (status, registrationResult) -> {
            response.setStatusCode(status.intValue());
            switch (status) {
                case 200: {
                    String msg = registrationResult.getJsonObject("payload").encodePrettily();
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(msg.length())).write(msg);
                }
            }
            response.end();
        });
    }

    private void doRegisterDeviceJson(RoutingContext ctx) {
        try {
            JsonObject payload = null;
            if (ctx.getBody().length() > 0) {
                payload = ctx.getBodyAsJson();
            }
            this.registerDevice(ctx, payload);
        }
        catch (DecodeException e) {
            HttpUtils.badRequest(ctx, "body does not contain a valid JSON object");
        }
    }

    private void registerDevice(RoutingContext ctx, JsonObject payload) {
        if (payload == null) {
            HttpUtils.badRequest(ctx, "missing body");
        } else {
            Object deviceId = payload.remove("device-id");
            if (deviceId == null) {
                HttpUtils.badRequest(ctx, String.format("'%s' param is required", "device-id"));
            } else if (!(deviceId instanceof String)) {
                HttpUtils.badRequest(ctx, String.format("'%s' must be a string", "device-id"));
            } else {
                String tenantId = RegistrationHttpEndpoint.getTenantParam(ctx);
                this.logger.debug("registering data for device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
                HttpServerResponse response = ctx.response();
                JsonObject requestMsg = RegistrationConstants.getServiceRequestAsJson((String)"register", (String)tenantId, (String)((String)deviceId), (JsonObject)payload);
                this.doRegistrationAction(ctx, requestMsg, (status, registrationResult) -> {
                    response.setStatusCode(status.intValue());
                    switch (status) {
                        case 201: {
                            response.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s/%s", "registration", tenantId, deviceId));
                        }
                    }
                    response.end();
                });
            }
        }
    }

    private void doUpdateRegistrationJson(RoutingContext ctx) {
        try {
            JsonObject payload = null;
            if (ctx.getBody().length() > 0) {
                payload = ctx.getBodyAsJson();
            }
            this.updateRegistration(RegistrationHttpEndpoint.getDeviceIdParam(ctx), payload, ctx);
        }
        catch (DecodeException e) {
            HttpUtils.badRequest(ctx, "body does not contain a valid JSON object");
        }
    }

    private void updateRegistration(String deviceId, JsonObject payload, RoutingContext ctx) {
        if (payload != null) {
            payload.remove("device-id");
        }
        String tenantId = RegistrationHttpEndpoint.getTenantParam(ctx);
        this.logger.debug("updating registration data for device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
        HttpServerResponse response = ctx.response();
        JsonObject requestMsg = RegistrationConstants.getServiceRequestAsJson((String)"update", (String)tenantId, (String)deviceId, (JsonObject)payload);
        this.doRegistrationAction(ctx, requestMsg, (status, registrationResult) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                RegistrationHttpEndpoint.setResponseBody(registrationResult, response);
            }
            response.end();
        });
    }

    private void doUnregisterDevice(RoutingContext ctx) {
        String deviceId = RegistrationHttpEndpoint.getDeviceIdParam(ctx);
        String tenantId = RegistrationHttpEndpoint.getTenantParam(ctx);
        this.logger.debug("removing registration information for device [tenant: {}, device: {}]", (Object)tenantId, (Object)deviceId);
        HttpServerResponse response = ctx.response();
        JsonObject requestMsg = RegistrationConstants.getServiceRequestAsJson((String)"deregister", (String)tenantId, (String)deviceId);
        this.doRegistrationAction(ctx, requestMsg, (status, registrationResult) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                RegistrationHttpEndpoint.setResponseBody(registrationResult, response);
            }
            response.end();
        });
    }

    private void doRegistrationAction(RoutingContext ctx, JsonObject requestMsg, BiConsumer<Integer, JsonObject> responseHandler) {
        this.vertx.eventBus().send("registration.in", (Object)requestMsg, invocation -> {
            if (invocation.failed()) {
                HttpUtils.serviceUnavailable(ctx, 2);
            } else {
                JsonObject registrationResult = (JsonObject)((Message)invocation.result()).body();
                Integer status = registrationResult.getInteger("status");
                responseHandler.accept(status, registrationResult);
            }
        });
    }
}

