/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.RequestResponseEndpoint;
import org.eclipse.hono.service.registration.RegistrationMessageFilter;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RegistrationConstants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;

public final class RegistrationAmqpEndpoint
extends RequestResponseEndpoint<ServiceConfigProperties> {
    @Autowired
    public RegistrationAmqpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public String getName() {
        return "registration";
    }

    @Override
    public void processRequest(org.apache.qpid.proton.message.Message msg, ResourceIdentifier targetAddress, HonoUser clientPrincipal) {
        JsonObject registrationMsg = RegistrationConstants.getRegistrationMsg((org.apache.qpid.proton.message.Message)msg, (ResourceIdentifier)targetAddress);
        this.vertx.eventBus().send("registration.in", (Object)registrationMsg, result -> {
            JsonObject response = null;
            if (result.succeeded()) {
                response = (JsonObject)((Message)result.result()).body();
            } else {
                this.logger.debug("failed to process request [msg ID: {}] due to {}", msg.getMessageId(), (Object)result.cause());
                response = RegistrationConstants.getServiceReplyAsJson((int)500, (String)targetAddress.getTenantId(), (String)MessageHelper.getDeviceId((org.apache.qpid.proton.message.Message)msg), null);
            }
            this.addHeadersToResponse(msg, response);
            this.vertx.eventBus().send(msg.getReplyTo(), (Object)response);
        });
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, org.apache.qpid.proton.message.Message msg) {
        return RegistrationMessageFilter.verify(linkTarget, msg);
    }

    @Override
    protected org.apache.qpid.proton.message.Message getAmqpReply(Message<JsonObject> message) {
        return RegistrationConstants.getAmqpReply((String)"registration", (JsonObject)((JsonObject)message.body()));
    }
}

