/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.service.registration.RegistrationAssertionHelper;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.util.ConfigurationSupportingVerticle;
import org.eclipse.hono.util.RegistrationConstants;
import org.eclipse.hono.util.RegistrationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseRegistrationService<T>
extends ConfigurationSupportingVerticle<T>
implements RegistrationService {
    public static final String PROPERTY_VIA = "via";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageConsumer<JsonObject> registrationConsumer;
    private RegistrationAssertionHelper assertionFactory;

    @Autowired
    @Qualifier(value="signing")
    public final void setRegistrationAssertionFactory(RegistrationAssertionHelper assertionFactory) {
        this.assertionFactory = Objects.requireNonNull(assertionFactory);
    }

    public final void start(Future<Void> startFuture) {
        if (this.assertionFactory == null) {
            startFuture.fail("registration assertion factory must be set");
        } else {
            this.registerConsumer();
            this.doStart(startFuture);
        }
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    private void registerConsumer() {
        this.registrationConsumer = this.vertx.eventBus().consumer("registration.in");
        this.registrationConsumer.handler(this::processRegistrationMessage);
        this.log.info("listening on event bus [address: {}] for incoming registration messages", (Object)"registration.in");
    }

    public final void stop(Future<Void> stopFuture) {
        this.log.info("unregistering event bus listener [address: {}]", (Object)"registration.in");
        this.registrationConsumer.unregister();
        this.doStop(stopFuture);
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    public final void processRegistrationMessage(Message<JsonObject> regMsg) {
        try {
            String operation;
            JsonObject body = (JsonObject)regMsg.body();
            String tenantId = body.getString("tenant-id");
            String deviceId = body.getString("device-id");
            String gatewayId = body.getString("gateway_id");
            switch (operation = body.getString("subject")) {
                case "assert": {
                    if (gatewayId == null) {
                        this.log.debug("asserting registration of device [{}] with tenant [{}]", (Object)deviceId, (Object)tenantId);
                        this.assertRegistration(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)((Handler)result -> this.reply(regMsg, (AsyncResult<RegistrationResult>)result)));
                        break;
                    }
                    this.log.debug("asserting registration of device [{}] with tenant [{}] for gateway [{}]", new Object[]{deviceId, tenantId, gatewayId});
                    this.assertRegistration(tenantId, deviceId, gatewayId, (Handler<AsyncResult<RegistrationResult>>)((Handler)result -> this.reply(regMsg, (AsyncResult<RegistrationResult>)result)));
                    break;
                }
                case "get": {
                    this.log.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
                    this.getDevice(tenantId, deviceId, result -> this.reply(regMsg, (AsyncResult<RegistrationResult>)result));
                    break;
                }
                case "register": {
                    JsonObject payload = this.getRequestPayload(body);
                    this.log.debug("registering device [{}] of tenant [{}] with data {}", new Object[]{deviceId, tenantId, payload != null ? payload.encode() : null});
                    this.addDevice(tenantId, deviceId, payload, result -> this.reply(regMsg, (AsyncResult<RegistrationResult>)result));
                    break;
                }
                case "update": {
                    JsonObject payload = this.getRequestPayload(body);
                    this.log.debug("updating registration for device [{}] of tenant [{}] with data {}", new Object[]{deviceId, tenantId, payload != null ? payload.encode() : null});
                    this.updateDevice(tenantId, deviceId, payload, result -> this.reply(regMsg, (AsyncResult<RegistrationResult>)result));
                    break;
                }
                case "deregister": {
                    this.log.debug("deregistering device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
                    this.removeDevice(tenantId, deviceId, result -> this.reply(regMsg, (AsyncResult<RegistrationResult>)result));
                    break;
                }
                default: {
                    this.log.info("operation [{}] not supported", (Object)operation);
                    this.reply(regMsg, RegistrationResult.from((int)400));
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            this.log.debug("malformed request message");
            this.reply(regMsg, RegistrationResult.from((int)400));
        }
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resultHandler);
        Future getResultTracker = Future.future();
        this.getDevice(tenantId, deviceId, getResultTracker.completer());
        getResultTracker.map(result -> {
            if (this.isDeviceEnabled((RegistrationResult)result)) {
                return RegistrationResult.from((int)200, (JsonObject)this.getAssertionPayload(tenantId, deviceId, ((JsonObject)result.getPayload()).getJsonObject("data")));
            }
            return RegistrationResult.from((int)404);
        }).setHandler(resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, String gatewayId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(resultHandler);
        Future deviceInfoTracker = Future.future();
        Future gatewayInfoTracker = Future.future();
        this.getDevice(tenantId, deviceId, deviceInfoTracker.completer());
        this.getDevice(tenantId, gatewayId, gatewayInfoTracker.completer());
        CompositeFuture.all((Future)deviceInfoTracker, (Future)gatewayInfoTracker).compose(ok -> {
            RegistrationResult deviceResult = (RegistrationResult)deviceInfoTracker.result();
            RegistrationResult gatewayResult = (RegistrationResult)gatewayInfoTracker.result();
            if (!this.isDeviceEnabled(deviceResult)) {
                return Future.succeededFuture((Object)RegistrationResult.from((int)404));
            }
            if (!this.isDeviceEnabled(gatewayResult)) {
                return Future.succeededFuture((Object)RegistrationResult.from((int)403));
            }
            JsonObject deviceData = ((JsonObject)deviceResult.getPayload()).getJsonObject("data", new JsonObject());
            JsonObject gatewayData = ((JsonObject)gatewayResult.getPayload()).getJsonObject("data", new JsonObject());
            if (this.isGatewayAuthorized(gatewayId, gatewayData, deviceId, deviceData)) {
                return Future.succeededFuture((Object)RegistrationResult.from((int)200, (JsonObject)this.getAssertionPayload(tenantId, deviceId, deviceData)));
            }
            return Future.succeededFuture((Object)RegistrationResult.from((int)403));
        }).setHandler(resultHandler);
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        return gatewayId.equals(deviceData.getString(PROPERTY_VIA));
    }

    private boolean isDeviceEnabled(RegistrationResult registrationResult) {
        return registrationResult.isOk() && this.isDeviceEnabled(((JsonObject)registrationResult.getPayload()).getJsonObject("data"));
    }

    private boolean isDeviceEnabled(JsonObject registrationData) {
        return registrationData.getBoolean("enabled", Boolean.TRUE);
    }

    protected final JsonObject getAssertionPayload(String tenantId, String deviceId, JsonObject registrationInfo) {
        JsonObject result = new JsonObject().put("device-id", deviceId).put("assertion", this.assertionFactory.getAssertion(tenantId, deviceId));
        JsonObject defaults = registrationInfo.getJsonObject("defaults");
        if (defaults != null) {
            result.put("defaults", defaults);
        }
        return result;
    }

    private void reply(Message<JsonObject> request, AsyncResult<RegistrationResult> result) {
        if (result.succeeded()) {
            this.reply(request, (RegistrationResult)result.result());
        } else {
            request.fail(500, "cannot process registration request");
        }
    }

    protected final void reply(Message<JsonObject> request, RegistrationResult result) {
        JsonObject body = (JsonObject)request.body();
        String tenantId = body.getString("tenant-id");
        String deviceId = body.getString("device-id");
        request.reply((Object)RegistrationConstants.getServiceReplyAsJson((String)tenantId, (String)deviceId, (RegistrationResult)result));
    }

    private JsonObject getRequestPayload(JsonObject request) {
        JsonObject payload = request.getJsonObject("payload", new JsonObject());
        Boolean enabled = payload.getBoolean("enabled");
        if (enabled == null) {
            this.log.debug("adding 'enabled' key to payload");
            payload.put("enabled", Boolean.TRUE);
        }
        return payload;
    }

    protected static final JsonObject getResultPayload(String deviceId, JsonObject data) {
        return new JsonObject().put("device-id", deviceId).put("data", data);
    }
}

