/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class HttpUtils {
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_JSON_UFT8 = "application/json; charset=utf-8";

    private HttpUtils() {
    }

    public static void badRequest(RoutingContext ctx, String msg) {
        HttpUtils.failWithStatus(ctx, 400, null, msg);
    }

    public static void internalServerError(RoutingContext ctx, String msg) {
        HttpUtils.failWithStatus(ctx, 500, null, msg);
    }

    public static void serviceUnavailable(RoutingContext ctx, int retryAfterSeconds) {
        HttpUtils.serviceUnavailable(ctx, retryAfterSeconds, null);
    }

    public static void serviceUnavailable(RoutingContext ctx, int retryAfterSeconds, String detail) {
        HashMap<CharSequence, CharSequence> headers = new HashMap<CharSequence, CharSequence>(1);
        headers.put(HttpHeaders.RETRY_AFTER, String.valueOf(retryAfterSeconds));
        HttpUtils.failWithStatus(ctx, 503, headers, detail);
    }

    public static void unauthorized(RoutingContext ctx, String authenticateHeaderValue) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(authenticateHeaderValue);
        HashMap<CharSequence, CharSequence> headers = new HashMap<CharSequence, CharSequence>();
        headers.put("WWW-Authenticate", authenticateHeaderValue);
        HttpUtils.failWithStatus(ctx, 401, headers, null);
    }

    public static void failWithStatus(RoutingContext ctx, int status, Map<CharSequence, CharSequence> headers, String detail) {
        Objects.requireNonNull(ctx);
        if (headers != null) {
            for (Map.Entry<CharSequence, CharSequence> header : headers.entrySet()) {
                ctx.response().putHeader(header.getKey(), header.getValue());
            }
        }
        if (detail != null) {
            ctx.response().setStatusMessage(detail);
        }
        ctx.fail(status);
    }

    public static String getContentType(RoutingContext ctx) {
        return Objects.requireNonNull(ctx).parsedHeaders().contentType().value();
    }
}

