/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialsMessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsMessageFilter.class);

    private CredentialsMessageFilter() {
    }

    public static boolean verify(ResourceIdentifier linkTarget, Message msg) {
        if (msg.getMessageId() == null && msg.getCorrelationId() == null) {
            LOG.trace("message has neither a message-id nor correlation-id");
            return false;
        }
        if (!CredentialsMessageFilter.hasValidSubject(msg)) {
            LOG.trace("message [{}] does not contain valid subject property", msg.getMessageId());
            return false;
        }
        if (msg.getReplyTo() == null) {
            LOG.trace("message [{}] has no reply-to address set", msg.getMessageId());
            return false;
        }
        if (!(msg.getBody() instanceof AmqpValue)) {
            LOG.trace("message [{}] contains non-AmqpValue section payload", msg.getMessageId());
            return false;
        }
        return true;
    }

    private static boolean hasValidSubject(Message msg) {
        String subject = msg.getSubject();
        return CredentialsConstants.isValidSubject((String)subject);
    }
}

