/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.CredentialsConstants;
import org.springframework.beans.factory.annotation.Autowired;

public final class CredentialsHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    private static final String KEY_REQUEST_BODY = "KEY_REQUEST_BODY";
    private static final String PARAM_TENANT_ID = "tenant_id";
    private static final String PARAM_DEVICE_ID = "device_id";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_AUTH_ID = "auth_id";

    @Autowired
    public CredentialsHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenant = String.format("/%s/:%s", "credentials", PARAM_TENANT_ID);
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", "credentials", PARAM_TENANT_ID, PARAM_DEVICE_ID);
        String pathWithTenantAndAuthIdAndType = String.format("/%s/:%s/:%s/:%s", "credentials", PARAM_TENANT_ID, PARAM_AUTH_ID, PARAM_TYPE);
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit(2048L);
        router.post(pathWithTenant).handler((Handler)bodyHandler);
        router.post(pathWithTenant).handler(this::extractRequiredJsonPayload);
        router.post(pathWithTenant).handler(this::addCredentials);
        router.get(pathWithTenantAndAuthIdAndType).handler(this::getCredentials);
        router.get(pathWithTenantAndDeviceId).handler(this::getCredentialsForDevice);
        router.put(pathWithTenantAndAuthIdAndType).handler((Handler)bodyHandler);
        router.put(pathWithTenantAndAuthIdAndType).handler(this::extractRequiredJsonPayload);
        router.put(pathWithTenantAndAuthIdAndType).handler(this::updateCredentials);
        router.delete(pathWithTenantAndAuthIdAndType).handler(this::removeCredentials);
        router.delete(pathWithTenantAndDeviceId).handler(this::removeCredentialsForDevice);
    }

    private static String getTenantParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TENANT_ID);
    }

    private static String getDeviceIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_DEVICE_ID);
    }

    private static String getTypeParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TYPE);
    }

    private static String getAuthIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_AUTH_ID);
    }

    @Override
    public String getName() {
        return "credentials";
    }

    private void extractRequiredJsonPayload(RoutingContext ctx) {
        MIMEHeader contentType = ctx.parsedHeaders().contentType();
        if (contentType == null) {
            ctx.response().setStatusMessage("Missing Content-Type header");
            ctx.fail(400);
        } else if (!"application/json".equalsIgnoreCase(contentType.value())) {
            ctx.response().setStatusMessage("Unsupported Content-Type");
            ctx.fail(400);
        } else {
            try {
                if (ctx.getBody() != null) {
                    ctx.put(KEY_REQUEST_BODY, (Object)ctx.getBodyAsJson());
                    ctx.next();
                } else {
                    ctx.response().setStatusMessage("Empty body");
                    ctx.fail(400);
                }
            }
            catch (DecodeException e) {
                ctx.response().setStatusMessage("Invalid JSON");
                ctx.fail(400);
            }
        }
    }

    private void addCredentials(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get(KEY_REQUEST_BODY);
        String deviceId = payload.getString("device-id");
        String authId = payload.getString("auth-id");
        String type = payload.getString(PARAM_TYPE);
        String tenantId = CredentialsHttpEndpoint.getTenantParam(ctx);
        this.logger.debug("adding credentials [tenant: {}, device-id: {}, auth-id: {}, type: {}]", new Object[]{tenantId, deviceId, authId, type});
        JsonObject requestMsg = CredentialsConstants.getServiceRequestAsJson((String)"add", (String)tenantId, (String)deviceId, (JsonObject)payload);
        this.doCredentialsAction(ctx, requestMsg, (status, addCredentialsResult) -> {
            HttpServerResponse response = ctx.response();
            response.setStatusCode(status.intValue());
            switch (status) {
                case 201: {
                    response.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s/%s/%s", "credentials", tenantId, authId, type));
                }
            }
            if (status >= 400) {
                CredentialsHttpEndpoint.setResponseBody(addCredentialsResult, response);
            }
            response.end();
        });
    }

    private void updateCredentials(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get(KEY_REQUEST_BODY);
        String deviceId = payload.getString("device-id");
        String authId = payload.getString("auth-id");
        String type = payload.getString(PARAM_TYPE);
        String tenantId = CredentialsHttpEndpoint.getTenantParam(ctx);
        String authIdFromUri = CredentialsHttpEndpoint.getAuthIdParam(ctx);
        String typeFromUri = CredentialsHttpEndpoint.getTypeParam(ctx);
        if (!authIdFromUri.equals(authId)) {
            ctx.response().setStatusMessage("Non-matching authentication identifier");
            ctx.fail(400);
        } else if (!typeFromUri.equals(type)) {
            ctx.response().setStatusMessage("Non-matching credentials type");
            ctx.fail(400);
        } else {
            this.logger.debug("updating credentials [tenant: {}, device-id: {}, auth-id: {}, type: {}]", new Object[]{tenantId, deviceId, authId, type});
            JsonObject requestMsg = CredentialsConstants.getServiceRequestAsJson((String)"update", (String)tenantId, (String)deviceId, (JsonObject)payload);
            this.doCredentialsAction(ctx, requestMsg, (status, updateCredentialsResult) -> {
                HttpServerResponse response = ctx.response();
                response.setStatusCode(status.intValue());
                if (status >= 400) {
                    CredentialsHttpEndpoint.setResponseBody(updateCredentialsResult, response);
                }
                response.end();
            });
        }
    }

    private void removeCredentials(RoutingContext ctx) {
        String tenantId = CredentialsHttpEndpoint.getTenantParam(ctx);
        String type = CredentialsHttpEndpoint.getTypeParam(ctx);
        String authId = CredentialsHttpEndpoint.getAuthIdParam(ctx);
        this.logger.debug("removeCredentials [tenant: {}, type: {}, authId: {}]", new Object[]{tenantId, type, authId});
        HttpServerResponse response = ctx.response();
        JsonObject payload = new JsonObject();
        payload.put(PARAM_TYPE, type);
        payload.put("auth-id", authId);
        JsonObject requestMsg = CredentialsConstants.getServiceRequestAsJson((String)"remove", (String)tenantId, null, (JsonObject)payload);
        this.doCredentialsAction(ctx, requestMsg, (status, removeCredentialsResult) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                CredentialsHttpEndpoint.setResponseBody(removeCredentialsResult, response);
            }
            response.end();
        });
    }

    private void removeCredentialsForDevice(RoutingContext ctx) {
        String tenantId = CredentialsHttpEndpoint.getTenantParam(ctx);
        String deviceId = CredentialsHttpEndpoint.getDeviceIdParam(ctx);
        this.logger.debug("removeCredentialsForDevice: [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
        HttpServerResponse response = ctx.response();
        JsonObject payload = new JsonObject();
        payload.put("device-id", deviceId);
        payload.put(PARAM_TYPE, "*");
        JsonObject requestMsg = CredentialsConstants.getServiceRequestAsJson((String)"remove", (String)tenantId, (String)deviceId, (JsonObject)payload);
        this.doCredentialsAction(ctx, requestMsg, (status, removeCredentialsResult) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                CredentialsHttpEndpoint.setResponseBody(removeCredentialsResult, response);
            }
            response.end();
        });
    }

    private void getCredentials(RoutingContext ctx) {
        String tenantId = CredentialsHttpEndpoint.getTenantParam(ctx);
        String authId = CredentialsHttpEndpoint.getAuthIdParam(ctx);
        String type = CredentialsHttpEndpoint.getTypeParam(ctx);
        this.logger.debug("getCredentials [tenant: {}, auth-id: {}, type: {}]", new Object[]{tenantId, authId, type});
        JsonObject requestMsg = CredentialsConstants.getServiceGetRequestAsJson((String)tenantId, null, (String)authId, (String)type);
        this.doCredentialsAction(ctx, requestMsg, (status, getCredentialsResult) -> {
            HttpServerResponse response = ctx.response();
            response.setStatusCode(status.intValue());
            if (status == 200 || status >= 400) {
                CredentialsHttpEndpoint.setResponseBody(getCredentialsResult, response);
            }
            response.end();
        });
    }

    private void getCredentialsForDevice(RoutingContext ctx) {
        String tenantId = CredentialsHttpEndpoint.getTenantParam(ctx);
        String deviceId = CredentialsHttpEndpoint.getDeviceIdParam(ctx);
        this.logger.debug("getCredentialsForDevice [tenant: {}, device-id: {}]]", (Object)tenantId, (Object)deviceId);
        JsonObject requestMsg = CredentialsConstants.getServiceGetRequestAsJson((String)tenantId, (String)deviceId, null, (String)"*");
        this.doCredentialsAction(ctx, requestMsg, (status, getCredentialsResult) -> {
            HttpServerResponse response = ctx.response();
            response.setStatusCode(status.intValue());
            if (status == 200 || status >= 400) {
                CredentialsHttpEndpoint.setResponseBody(getCredentialsResult, response);
            }
            response.end();
        });
    }

    private void doCredentialsAction(RoutingContext ctx, JsonObject requestMsg, BiConsumer<Integer, JsonObject> responseHandler) {
        this.vertx.eventBus().send("credentials.in", (Object)requestMsg, invocation -> {
            if (invocation.failed()) {
                HttpUtils.serviceUnavailable(ctx, 2);
            } else {
                JsonObject credentialsResult = (JsonObject)((Message)invocation.result()).body();
                Integer status = credentialsResult.getInteger("status");
                responseHandler.accept(status, credentialsResult);
            }
        });
    }

    private static void setResponseBody(JsonObject registrationResult, HttpServerResponse response) {
        JsonObject msg = registrationResult.getJsonObject("payload");
        if (msg != null) {
            String body = msg.encodePrettily();
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(body.length())).write(body);
        }
    }
}

