/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.RequestResponseEndpoint;
import org.eclipse.hono.service.credentials.CredentialsMessageFilter;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;

public final class CredentialsAmqpEndpoint
extends RequestResponseEndpoint<ServiceConfigProperties> {
    @Autowired
    public CredentialsAmqpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public String getName() {
        return "credentials";
    }

    @Override
    public void processRequest(org.apache.qpid.proton.message.Message msg, ResourceIdentifier targetAddress, HonoUser clientPrincipal) {
        JsonObject credentialsMsg = CredentialsConstants.getCredentialsMsg((org.apache.qpid.proton.message.Message)msg, (ResourceIdentifier)targetAddress);
        this.vertx.eventBus().send("credentials.in", (Object)credentialsMsg, result -> {
            JsonObject response = null;
            if (result.succeeded()) {
                response = (JsonObject)((Message)result.result()).body();
            } else {
                this.logger.debug("failed to process credentials request [msg ID: {}] due to {}", msg.getMessageId(), (Object)result.cause());
                response = CredentialsConstants.getServiceReplyAsJson((int)500, (String)targetAddress.getTenantId(), null, null);
            }
            this.addHeadersToResponse(msg, response);
            this.vertx.eventBus().send(msg.getReplyTo(), (Object)response);
        });
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, org.apache.qpid.proton.message.Message msg) {
        return CredentialsMessageFilter.verify(linkTarget, msg);
    }

    @Override
    protected org.apache.qpid.proton.message.Message getAmqpReply(Message<JsonObject> message) {
        return CredentialsConstants.getAmqpReply((String)"credentials", (JsonObject)((JsonObject)message.body()));
    }
}

