/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.util.ConfigurationSupportingVerticle;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class BaseCredentialsService<T>
extends ConfigurationSupportingVerticle<T>
implements CredentialsService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageConsumer<JsonObject> credentialsConsumer;

    public final void start(Future<Void> startFuture) throws Exception {
        this.credentialsConsumer();
        this.doStart(startFuture);
    }

    protected void doStart(Future<Void> startFuture) throws Exception {
        startFuture.complete();
    }

    private void credentialsConsumer() {
        this.credentialsConsumer = this.vertx.eventBus().consumer("credentials.in");
        this.credentialsConsumer.handler(this::processCredentialsMessage);
        this.log.info("listening on event bus [address: {}] for incoming credentials messages", (Object)"credentials.in");
    }

    public final void stop(Future<Void> stopFuture) {
        this.log.info("unregistering event bus listener [address: {}]", (Object)"credentials.in");
        this.credentialsConsumer.unregister();
        this.doStop(stopFuture);
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    public final void processCredentialsMessage(Message<JsonObject> regMsg) {
        JsonObject body = (JsonObject)regMsg.body();
        if (body == null) {
            this.log.debug("credentials request does not contain body");
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        this.log.trace("credentials request message: {}", (Object)body.encodePrettily());
        String tenantId = body.getString("tenant-id");
        String subject = body.getString("subject");
        JsonObject payload = this.getRequestPayload(body);
        if (tenantId == null) {
            this.log.debug("credentials request does not contain mandatory property [{}]", (Object)"tenant-id");
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        if (subject == null) {
            this.log.debug("credentials request does not contain mandatory property [{}]", (Object)"subject");
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        if (payload == null) {
            this.log.debug("credentials request contains invalid or no payload at all (expected JSON)");
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        switch (subject) {
            case "get": {
                this.processCredentialsMessageGetOperation(regMsg, tenantId, payload);
                break;
            }
            case "add": {
                this.processCredentialsMessageAddOperation(regMsg, tenantId, payload);
                break;
            }
            case "update": {
                this.processCredentialsMessageUpdateOperation(regMsg, tenantId, payload);
                break;
            }
            case "remove": {
                this.processCredentialsMessageRemoveOperation(regMsg, tenantId, payload);
                break;
            }
            default: {
                this.log.debug("operation [{}] not supported", (Object)subject);
                this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            }
        }
    }

    private void processCredentialsMessageGetOperation(Message<JsonObject> regMsg, String tenantId, JsonObject payload) {
        String type = this.getTypesafeValueForField(payload, "type", String.class);
        if (type == null) {
            this.log.debug("get credentials request does not contain required parameter [{}]", (Object)"type");
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        String authId = this.getTypesafeValueForField(payload, "auth-id", String.class);
        String deviceId = this.getTypesafeValueForField(payload, "device-id", String.class);
        if (authId != null && deviceId == null) {
            this.log.debug("getting credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            this.get(tenantId, type, authId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)((Handler)result -> this.reply(regMsg, (AsyncResult<CredentialsResult<JsonObject>>)result)));
        } else if (deviceId != null && authId == null) {
            this.log.debug("getting credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            this.getAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)((Handler)result -> this.reply(regMsg, (AsyncResult<CredentialsResult<JsonObject>>)result)));
        } else {
            this.log.debug("get credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
        }
    }

    private void processCredentialsMessageAddOperation(Message<JsonObject> regMsg, String tenantId, JsonObject payload) {
        if (!this.isValidCredentialsObject(payload)) {
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        this.add(tenantId, payload, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)((Handler)result -> this.reply(regMsg, (AsyncResult<CredentialsResult<JsonObject>>)result)));
    }

    private void processCredentialsMessageUpdateOperation(Message<JsonObject> regMsg, String tenantId, JsonObject payload) {
        if (!this.isValidCredentialsObject(payload)) {
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
            return;
        }
        this.update(tenantId, payload, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)((Handler)result -> this.reply(regMsg, (AsyncResult<CredentialsResult<JsonObject>>)result)));
    }

    private void processCredentialsMessageRemoveOperation(Message<JsonObject> regMsg, String tenantId, JsonObject payload) {
        String deviceId = this.getTypesafeValueForField(payload, "device-id", String.class);
        String type = this.getTypesafeValueForField(payload, "type", String.class);
        String authId = this.getTypesafeValueForField(payload, "auth-id", String.class);
        if (type == null) {
            this.log.debug("remove credentials request does not contain mandatory type parameter");
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
        } else if (!type.equals("*") && authId != null) {
            this.log.debug("removing specific credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            this.remove(tenantId, type, authId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)((Handler)result -> this.reply(regMsg, (AsyncResult<CredentialsResult<JsonObject>>)result)));
        } else if (deviceId != null && type.equals("*")) {
            this.log.debug("removing all credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            this.removeAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)((Handler)result -> this.reply(regMsg, (AsyncResult<CredentialsResult<JsonObject>>)result)));
        } else {
            this.log.debug("remove credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
            this.reply(regMsg, (CredentialsResult<JsonObject>)CredentialsResult.from((int)400));
        }
    }

    @Override
    public void add(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void get(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void getAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    private void handleUnimplementedOperation(Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)CredentialsResult.from((int)501)));
    }

    private boolean isValidCredentialsObject(JsonObject credentials) {
        return this.containsStringValueForField(credentials, "device-id") && this.containsStringValueForField(credentials, "type") && this.containsStringValueForField(credentials, "auth-id") && this.containsValidSecretValue(credentials);
    }

    private boolean containsValidSecretValue(JsonObject credentials) {
        Object obj = credentials.getValue("secrets");
        if (JsonArray.class.isInstance(obj)) {
            JsonArray secrets = (JsonArray)obj;
            if (secrets.isEmpty()) {
                this.log.debug("credentials request payload contains no secrets");
                return false;
            }
            for (int i = 0; i < secrets.size(); ++i) {
                JsonObject currentSecret = secrets.getJsonObject(i);
                if (this.containsValidTimestampIfPresentForField(currentSecret, "not-before") && this.containsValidTimestampIfPresentForField(currentSecret, "not-after")) continue;
                this.log.debug("credentials request contains invalid timestamp values in payload");
                return false;
            }
            return true;
        }
        this.log.debug("credentials request does not contain a {} array in payload - not supported", (Object)"secrets");
        return false;
    }

    private boolean containsStringValueForField(JsonObject payload, String field) {
        Object value = payload.getValue(field);
        if (StringUtils.isEmpty((Object)value)) {
            this.log.debug("credentials request payload does not contain required string typed field [{}]", (Object)field);
            return false;
        }
        return true;
    }

    protected final <T> T getTypesafeValueForField(JsonObject payload, String field, Class<T> type) {
        Objects.requireNonNull(payload);
        Objects.requireNonNull(field);
        Objects.requireNonNull(type);
        Object value = payload.getValue(field);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    private boolean containsValidTimestampIfPresentForField(JsonObject payload, String field) {
        Object value = payload.getValue(field);
        if (value == null) {
            return true;
        }
        if (String.class.isInstance(value)) {
            return this.isValidTimestamp((String)value);
        }
        return false;
    }

    private boolean isValidTimestamp(String dateTime) {
        try {
            DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
            timeFormatter.parse(dateTime);
            return true;
        }
        catch (DateTimeParseException e) {
            this.log.debug("credentials request did contain invalid timestamp in payload");
            return false;
        }
    }

    private void reply(Message<JsonObject> request, AsyncResult<CredentialsResult<JsonObject>> result) {
        if (result.succeeded()) {
            this.reply(request, (CredentialsResult<JsonObject>)((CredentialsResult)result.result()));
        } else {
            request.fail(500, "cannot process credentials request");
        }
    }

    protected final void reply(Message<JsonObject> request, CredentialsResult<JsonObject> result) {
        JsonObject body = (JsonObject)request.body();
        String tenantId = body.getString("tenant-id");
        String deviceId = body.getString("device-id");
        request.reply((Object)CredentialsConstants.getServiceReplyAsJson((String)tenantId, (String)deviceId, result));
    }

    private JsonObject getRequestPayload(JsonObject request) {
        if (request == null) {
            return null;
        }
        JsonObject payload = null;
        Object payloadObject = request.getValue("payload");
        if (JsonObject.class.isInstance(payloadObject) && !(payload = (JsonObject)payloadObject).containsKey("enabled")) {
            this.log.debug("adding 'enabled' key to payload");
            payload.put("enabled", Boolean.TRUE);
        }
        return payload;
    }

    protected static final JsonObject getResultPayload(String deviceId, String type, String authId, boolean enabled, JsonArray secrets) {
        return new JsonObject().put("device-id", deviceId).put("type", type).put("auth-id", authId).put("enabled", Boolean.valueOf(enabled)).put("secrets", secrets);
    }
}

