/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import org.eclipse.hono.service.auth.device.AbstractDeviceCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordCredentials
extends AbstractDeviceCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordCredentials.class);
    private String authId;
    private String password;
    private String tenantId;

    public static final UsernamePasswordCredentials create(String username, String password, boolean singleTenant) {
        if (username == null) {
            LOG.trace("username must not be null");
            return null;
        }
        if (password == null) {
            LOG.trace("password must not be null");
            return null;
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials();
        if (singleTenant) {
            credentials.authId = username;
            credentials.tenantId = "DEFAULT_TENANT";
        } else {
            String[] userComponents = username.split("@", 2);
            if (userComponents.length != 2) {
                LOG.trace("username does not comply with expected pattern [<authId>@<tenantId>]", (Object)username);
                return null;
            }
            credentials.authId = userComponents[0];
            credentials.tenantId = userComponents[1];
        }
        credentials.password = password;
        return credentials;
    }

    @Override
    public final String getType() {
        return "hashed-password";
    }

    @Override
    public final String getAuthId() {
        return this.authId;
    }

    public final String getPassword() {
        return this.password;
    }

    @Override
    public final String getTenantId() {
        return this.tenantId;
    }

    @Override
    public boolean matchesCredentials(Map<String, String> candidateSecret) {
        String pwdHash = candidateSecret.get("pwd-hash");
        if (pwdHash == null) {
            return false;
        }
        byte[] hashedPasswordOnRecord = Base64.getDecoder().decode(pwdHash);
        byte[] salt = null;
        String encodedSalt = candidateSecret.get("salt");
        if (encodedSalt != null) {
            salt = Base64.getDecoder().decode(encodedSalt);
        }
        String hashFunction = candidateSecret.getOrDefault("hash-function", "sha-256");
        return this.checkPassword(hashFunction, salt, hashedPasswordOnRecord);
    }

    private boolean checkPassword(String hashFunction, byte[] salt, byte[] hashedPasswordOnRecord) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashFunction);
            if (salt != null) {
                messageDigest.update(salt);
            }
            byte[] hashedPassword = messageDigest.digest(this.getPassword().getBytes(StandardCharsets.UTF_8));
            return Arrays.equals(hashedPassword, hashedPasswordOnRecord);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }
}

