/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.CredentialsClient;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.auth.device.Device;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.service.auth.device.HonoClientBasedAuthProvider;
import org.eclipse.hono.util.CredentialsObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class CredentialsApiAuthProvider
implements HonoClientBasedAuthProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Vertx vertx;
    private HonoClient credentialsClient;
    private AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    protected CredentialsApiAuthProvider(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    @Qualifier(value="credentials")
    @Autowired
    public final void setCredentialsServiceClient(HonoClient credentialsServiceClient) {
        this.credentialsClient = Objects.requireNonNull(credentialsServiceClient);
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("connected-to-credentials-service", status -> {
            Future checkResult = Optional.ofNullable(this.credentialsClient).map(client -> client.isConnected()).orElse(Future.succeededFuture((Object)Boolean.FALSE));
            checkResult.map(connected -> {
                if (connected.booleanValue()) {
                    status.tryComplete((Object)Status.OK());
                } else {
                    status.tryComplete((Object)Status.KO());
                }
                return null;
            });
        });
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    @Override
    public final Future<Void> start() {
        if (this.credentialsClient == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("Credentials service client is not set"));
        }
        return this.credentialsClient.connect(this.createClientOptions(), this::onDisconnectCredentialsService).map(connectedClient -> {
            this.log.info("connected to Credentials service");
            return null;
        }).recover(t -> {
            this.log.warn("connection to Credentials service failed", t);
            return Future.failedFuture((Throwable)t);
        });
    }

    private void onDisconnectCredentialsService(ProtonConnection con) {
        if (this.shutdownInProgress.get()) {
            this.log.debug("shut down in progress, not trying to re-connect to Credentials service");
        } else {
            this.vertx.setTimer(500L, reconnect -> {
                this.log.info("attempting to reconnect to Credentials service");
                this.credentialsClient.connect(this.createClientOptions(), this::onDisconnectCredentialsService).setHandler(connectAttempt -> {
                    if (connectAttempt.succeeded()) {
                        this.log.info("reconnected to Credentials service");
                    } else {
                        this.log.debug("cannot reconnect to Credentials service");
                    }
                });
            });
        }
    }

    @Override
    public final Future<Void> stop() {
        this.shutdownInProgress.set(true);
        Future result = Future.future();
        if (this.credentialsClient == null) {
            result.complete();
        } else {
            this.credentialsClient.shutdown(result.completer());
        }
        return result;
    }

    private ProtonClientOptions createClientOptions() {
        return new ProtonClientOptions().setConnectTimeout(200).setReconnectAttempts(1).setReconnectInterval(500L);
    }

    protected final Future<CredentialsClient> getCredentialsServiceClient(String tenantId) {
        if (this.credentialsClient == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("no credentials client set"));
        }
        return this.credentialsClient.getOrCreateCredentialsClient(tenantId);
    }

    protected final Future<CredentialsObject> getCredentialsForDevice(DeviceCredentials deviceCredentials) {
        Objects.requireNonNull(deviceCredentials);
        if (this.credentialsClient == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("Credentials API client is not set"));
        }
        return this.getCredentialsServiceClient(deviceCredentials.getTenantId()).compose(client -> client.get(deviceCredentials.getType(), deviceCredentials.getAuthId()));
    }

    @Override
    public final void authenticate(DeviceCredentials deviceCredentials, Handler<AsyncResult<Device>> resultHandler) {
        Objects.requireNonNull(deviceCredentials);
        Objects.requireNonNull(resultHandler);
        Future validationResult = Future.future();
        validationResult.setHandler(resultHandler);
        this.getCredentialsForDevice(deviceCredentials).recover(t -> {
            ServiceInvocationException e = (ServiceInvocationException)t;
            if (e.getErrorCode() == 404) {
                return Future.failedFuture((Throwable)new ClientErrorException(401, "bad credentials"));
            }
            return Future.failedFuture((Throwable)t);
        }).map(credentialsOnRecord -> {
            if (deviceCredentials.validate((CredentialsObject)credentialsOnRecord)) {
                return new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId());
            }
            throw new ClientErrorException(401, "invalid credentials");
        }).setHandler(resultHandler);
    }

    public final void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        DeviceCredentials credentials = this.getCredentials(Objects.requireNonNull(authInfo));
        if (credentials == null) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(401, "malformed credentials")));
        } else {
            this.authenticate(credentials, (Handler<AsyncResult<Device>>)((Handler)s -> {
                if (s.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)s.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)s.cause()));
                }
            }));
        }
    }

    protected abstract DeviceCredentials getCredentials(JsonObject var1);
}

