/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.util.CredentialsObject;

public abstract class AbstractDeviceCredentials
implements DeviceCredentials {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    @Override
    public final boolean validate(CredentialsObject credentialsOnRecord) {
        Objects.requireNonNull(credentialsOnRecord);
        if (!this.getAuthId().equals(credentialsOnRecord.getAuthId())) {
            return false;
        }
        if (!this.getType().equals(credentialsOnRecord.getType())) {
            return false;
        }
        if (!credentialsOnRecord.getEnabled().booleanValue()) {
            return false;
        }
        List secrets = credentialsOnRecord.getSecrets();
        if (secrets == null) {
            throw new IllegalArgumentException(String.format("credentials not validated - mandatory field %s is null", "secrets"));
        }
        return this.validate(secrets);
    }

    private boolean validate(List<Map<String, String>> secretsOnRecord) {
        for (Map<String, String> candidateSecret : secretsOnRecord) {
            if (!this.isInValidityPeriod(candidateSecret, Instant.now()) || !this.matchesCredentials(candidateSecret)) continue;
            return true;
        }
        return false;
    }

    private boolean isInValidityPeriod(Map<String, String> secret, Instant instant) {
        try {
            Instant notBefore = this.getInstant(secret, "not-before");
            Instant notAfter = this.getInstant(secret, "not-after");
            return !(notBefore != null && !instant.isAfter(notBefore) || notAfter != null && !instant.isBefore(notAfter));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Instant getInstant(Map<String, String> secret, String propertyName) {
        String timestamp = Objects.requireNonNull(secret).get(Objects.requireNonNull(propertyName));
        if (timestamp == null) {
            return null;
        }
        try {
            OffsetDateTime dateTime = DATE_TIME_FORMATTER.parse((CharSequence)timestamp, OffsetDateTime::from);
            return dateTime == null ? null : dateTime.toInstant();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("illegal timestamp format");
        }
    }

    public abstract boolean matchesCredentials(Map<String, String> var1);
}

