/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import io.vertx.core.Vertx;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.connection.ConnectionFactory;
import org.eclipse.hono.connection.ConnectionFactoryImpl;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthTokenHelperImpl;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"!authentication-impl"})
public class DelegatingAuthenticationServiceConfig {
    @Bean
    @ConfigurationProperties(prefix="hono.auth")
    @Qualifier(value="authentication")
    public AuthenticationServerClientConfigProperties authenticationServiceClientProperties() {
        return new AuthenticationServerClientConfigProperties();
    }

    @Bean
    @Qualifier(value="authentication")
    public ConnectionFactory authenticationServiceConnectionFactory(Vertx vertx) {
        return new ConnectionFactoryImpl(vertx, (ClientConfigProperties)this.authenticationServiceClientProperties());
    }

    @Bean
    @Qualifier(value="authentication")
    public AuthTokenHelper tokenValidator(Vertx vertx) {
        AuthenticationServerClientConfigProperties authClientProps = this.authenticationServiceClientProperties();
        if (!authClientProps.getValidation().isAppropriateForValidating() && authClientProps.getCertPath() != null) {
            authClientProps.getValidation().setCertPath(authClientProps.getCertPath());
        }
        return AuthTokenHelperImpl.forValidating(vertx, authClientProps.getValidation());
    }
}

