/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonReceiver;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.auth.HonoUserAdapter;
import org.eclipse.hono.connection.ConnectionFactory;
import org.eclipse.hono.util.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public final class AuthenticationServerClient {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationServerClient.class);
    private final ConnectionFactory factory;
    private final Vertx vertx;

    @Autowired
    public AuthenticationServerClient(Vertx vertx, @Qualifier(value="authentication") ConnectionFactory connectionFactory) {
        this.vertx = Objects.requireNonNull(vertx);
        this.factory = Objects.requireNonNull(connectionFactory);
    }

    public void verifyExternal(String authzid, String subjectDn, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        authenticationResultHandler.handle((Object)Future.failedFuture((String)"unsupported mechanism"));
    }

    public void verifyPlain(String authzid, String authcid, String password, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        ProtonClientOptions options = new ProtonClientOptions();
        options.setReconnectAttempts(3).setReconnectInterval(50L);
        options.addEnabledSaslMechanism("PLAIN");
        this.factory.connect(options, authcid, password, null, null, conAttempt -> {
            if (conAttempt.failed()) {
                authenticationResultHandler.handle((Object)Future.failedFuture((String)"cannot connect to Authentication service"));
            } else {
                ProtonConnection openCon = (ProtonConnection)conAttempt.result();
                Future userTracker = Future.future();
                userTracker.setHandler(s -> {
                    if (s.succeeded()) {
                        authenticationResultHandler.handle((Object)Future.succeededFuture((Object)s.result()));
                    } else {
                        authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)s.cause()));
                    }
                    ProtonConnection con = (ProtonConnection)conAttempt.result();
                    if (con != null) {
                        LOG.debug("closing connection to Authentication service");
                        con.close();
                    }
                });
                this.vertx.setTimer(5000L, tid -> {
                    if (!userTracker.isComplete()) {
                        userTracker.fail("time out reached while waiting for token from Authentication service");
                    }
                });
                this.getToken(openCon, (Future<HonoUser>)userTracker);
            }
        });
    }

    private void getToken(ProtonConnection openCon, Future<HonoUser> authResult) {
        ProtonMessageHandler messageHandler = (delivery, message) -> {
            String type = (String)MessageHelper.getApplicationProperty((ApplicationProperties)message.getApplicationProperties(), (String)"type", String.class);
            if ("amqp:jwt".equals(type)) {
                Section body = message.getBody();
                if (body instanceof AmqpValue) {
                    final String token = ((AmqpValue)body).getValue().toString();
                    HonoUserAdapter user = new HonoUserAdapter(){

                        public String getToken() {
                            return token;
                        }
                    };
                    LOG.debug("successfully retrieved token from Authentication service");
                    authResult.complete((Object)user);
                } else {
                    authResult.fail("message from Authentication service contains no body");
                }
            } else {
                authResult.fail("Authentication service issued unsupported token [type: " + type + "]");
            }
        };
        AuthenticationServerClient.openReceiver(openCon, messageHandler).compose(openReceiver -> LOG.debug("opened receiver link to Authentication service, waiting for token ..."), authResult);
    }

    private static Future<ProtonReceiver> openReceiver(ProtonConnection openConnection, ProtonMessageHandler messageHandler) {
        Future result = Future.future();
        ((ProtonReceiver)openConnection.createReceiver("cbs").openHandler(result.completer())).handler(messageHandler).open();
        return result;
    }
}

