/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.service.auth.AuthenticationConstants;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HonoSaslAuthenticator
implements ProtonSaslAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(HonoSaslAuthenticator.class);
    private final AuthenticationService authenticationService;
    private Sasl sasl;
    private boolean succeeded;
    private ProtonConnection protonConnection;
    private X509Certificate[] peerCertificateChain;

    public HonoSaslAuthenticator(AuthenticationService authService) {
        this.authenticationService = Objects.requireNonNull(authService);
    }

    public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
        LOG.debug("initializing SASL authenticator");
        this.protonConnection = protonConnection;
        this.sasl = transport.sasl();
        this.sasl.server();
        this.sasl.allowSkip(false);
        this.sasl.setMechanisms(new String[]{"EXTERNAL", "PLAIN"});
        if (socket.isSsl()) {
            LOG.debug("client connected using TLS, extracting client certificate chain");
            try {
                this.peerCertificateChain = socket.peerCertificateChain();
                LOG.debug("found valid client certificate DN [{}]", (Object)this.peerCertificateChain[0].getSubjectDN());
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.debug("could not extract client certificate chain, maybe TLS based client auth is not required");
            }
        }
    }

    public void process(Handler<Boolean> completionHandler) {
        String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
        if (remoteMechanisms.length == 0) {
            LOG.debug("client provided an empty list of SASL mechanisms [hostname: {}, state: {}]", (Object)this.sasl.getHostname(), (Object)this.sasl.getState().name());
            completionHandler.handle((Object)false);
        } else {
            String chosenMechanism = remoteMechanisms[0];
            LOG.debug("client wants to authenticate using SASL [mechanism: {}, host: {}, state: {}]", new Object[]{chosenMechanism, this.sasl.getHostname(), this.sasl.getState().name()});
            Future authTracker = Future.future();
            authTracker.setHandler(s -> {
                if (s.succeeded()) {
                    HonoUser user = (HonoUser)s.result();
                    LOG.debug("authentication of client [authorization ID: {}] succeeded", (Object)user.getName());
                    Constants.setClientPrincipal((ProtonConnection)this.protonConnection, (HonoUser)user);
                    this.succeeded = true;
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                } else {
                    LOG.debug("authentication failed: " + s.cause().getMessage());
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                }
                completionHandler.handle((Object)Boolean.TRUE);
            });
            byte[] saslResponse = new byte[this.sasl.pending()];
            this.sasl.recv(saslResponse, 0, saslResponse.length);
            this.verify(chosenMechanism, saslResponse, (Handler<AsyncResult<HonoUser>>)authTracker.completer());
        }
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    private void verify(String mechanism, byte[] saslResponse, Handler<AsyncResult<HonoUser>> authResultHandler) {
        JsonObject authRequest = AuthenticationConstants.getAuthenticationRequest(mechanism, saslResponse);
        if (this.peerCertificateChain != null) {
            authRequest.put("subject-dn", this.peerCertificateChain[0].getSubjectDN().getName());
        }
        this.authenticationService.authenticate(authRequest, authResultHandler);
    }
}

