/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.service.auth.AuthorizationConstants;
import org.eclipse.hono.service.auth.AuthorizationService;
import org.eclipse.hono.util.ResourceIdentifier;

public final class EventBusBasedAuthorizationService
implements AuthorizationService {
    private final Vertx vertx;

    public EventBusBasedAuthorizationService(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    @Override
    public Future<Boolean> isAuthorized(HonoUser user, ResourceIdentifier resource, Activity intent) {
        Future result = Future.future();
        JsonObject authRequest = AuthorizationConstants.getAuthorizationMsg(user.getName(), resource.toString(), intent.toString());
        this.vertx.eventBus().send("authorization.in", (Object)authRequest, res -> result.complete((Object)(res.succeeded() && "allowed".equals(((Message)res.result()).body()) ? 1 : 0)));
        return result;
    }

    @Override
    public Future<Boolean> isAuthorized(HonoUser user, ResourceIdentifier resource, String operation) {
        return Future.succeededFuture((Object)Boolean.FALSE);
    }
}

