/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Future;
import java.util.Objects;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.service.auth.AuthorizationService;
import org.eclipse.hono.util.ResourceIdentifier;

public final class ClaimsBasedAuthorizationService
implements AuthorizationService {
    @Override
    public Future<Boolean> isAuthorized(HonoUser user, ResourceIdentifier resource, Activity intent) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(resource);
        Objects.requireNonNull(intent);
        if (user.isExpired()) {
            return Future.failedFuture((String)"user information expired");
        }
        return Future.succeededFuture((Object)user.getAuthorities().isAuthorized(resource, intent));
    }

    @Override
    public Future<Boolean> isAuthorized(HonoUser user, ResourceIdentifier resource, String operation) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(resource);
        Objects.requireNonNull(operation);
        if (user.isExpired()) {
            return Future.failedFuture((String)"user information expired");
        }
        return Future.succeededFuture((Object)user.getAuthorities().isAuthorized(resource, operation));
    }
}

