/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.auth.HonoUserAdapter;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.auth.AuthorizationService;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseAuthorizationService
extends AbstractVerticle
implements AuthorizationService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAuthorizationService.class);
    private MessageConsumer<JsonObject> authRequestConsumer;
    private ServiceConfigProperties config = new ServiceConfigProperties();

    @Autowired(required=false)
    public final void setConfig(ServiceConfigProperties props) {
        this.config = Objects.requireNonNull(props);
    }

    public final ServiceConfigProperties getConfig() {
        return this.config;
    }

    public final void start(Future<Void> startFuture) {
        String listenAddress = "authorization.in";
        this.authRequestConsumer = this.vertx.eventBus().consumer(listenAddress);
        this.authRequestConsumer.handler(this::processMessage);
        LOG.info("listening on event bus [address: {}] for incoming auth messages", (Object)listenAddress);
        this.doStart(startFuture);
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    public final void stop(Future<Void> stopFuture) {
        this.authRequestConsumer.unregister();
        this.doStop(stopFuture);
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    private void processMessage(Message<JsonObject> message) {
        JsonObject body = (JsonObject)message.body();
        final String authSubject = body.getString("auth-subject");
        HonoUserAdapter user = new HonoUserAdapter(){

            public String getName() {
                return authSubject;
            }
        };
        Activity permission = Activity.valueOf((String)body.getString("permission"));
        ResourceIdentifier resource = ResourceIdentifier.fromString((String)body.getString("resource"));
        this.isAuthorized((HonoUser)user, resource, permission).setHandler(authAttempt -> {
            boolean hasPermission = false;
            if (authAttempt.succeeded()) {
                hasPermission = (Boolean)authAttempt.result();
            }
            LOG.debug("subject [{}] is {}allowed to {} on resource [{}]", new Object[]{authSubject, hasPermission ? "" : "not ", permission, resource});
            message.reply((Object)(hasPermission ? "allowed" : "denied"));
        });
    }
}

