/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AuthenticationConstants {
    public static final String APPLICATION_PROPERTY_TYPE = "type";
    public static final String ENDPOINT_NAME_AUTHENTICATION = "cbs";
    public static final String EVENT_BUS_ADDRESS_AUTHENTICATION_IN = "authentication.in";
    public static final String FIELD_AUTHORIZATION_ID = "authorization-id";
    public static final String FIELD_MECHANISM = "mechanism";
    public static final String FIELD_SASL_RESPONSE = "sasl-response";
    public static final String FIELD_SUBJECT_DN = "subject-dn";
    public static final String FIELD_TOKEN = "token";
    public static final String MECHANISM_PLAIN = "PLAIN";
    public static final String MECHANISM_EXTERNAL = "EXTERNAL";
    public static final int ERROR_CODE_UNSUPPORTED_MECHANISM = 0;
    public static final int ERROR_CODE_AUTHENTICATION_FAILED = 10;
    public static final String QUALIFIER_AUTHENTICATION = "authentication";
    public static final String TYPE_AMQP_JWT = "amqp:jwt";
    private static final Pattern PATTERN_CN = Pattern.compile("^CN=(.+?)(?:,\\s*[A-Z]{1,2}=.+|$)");

    private AuthenticationConstants() {
    }

    public static JsonObject getAuthenticationRequest(String mechanism, byte[] saslResponse) {
        return new JsonObject().put(FIELD_MECHANISM, Objects.requireNonNull(mechanism)).put(FIELD_SASL_RESPONSE, Objects.requireNonNull(saslResponse));
    }

    public static JsonObject getAuthenticationReply(String token) {
        return new JsonObject().put(FIELD_TOKEN, Objects.requireNonNull(token));
    }

    public static String getCommonName(String subject) {
        Matcher matcher = PATTERN_CN.matcher(subject);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

