/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.amqp;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.service.AbstractEndpoint;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractAmqpEndpoint<T>
extends AbstractEndpoint
implements AmqpEndpoint {
    protected T config;

    protected AbstractAmqpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Qualifier(value="amqp")
    @Autowired(required=false)
    public final void setConfiguration(T props) {
        this.config = Objects.requireNonNull(props);
    }

    protected void onLinkDetach(ProtonReceiver client) {
        this.onLinkDetach(client, (ErrorCondition)null);
    }

    protected final void onLinkDetach(ProtonLink<?> client, ErrorCondition error) {
        if (error == null) {
            this.logger.debug("closing link [{}]", (Object)client.getName());
        } else {
            this.logger.debug("closing link [{}]: {}", (Object)client.getName(), (Object)error.getDescription());
            client.setCondition(error);
        }
        client.close();
    }

    protected void onLinkDetach(ProtonReceiver client, ErrorCondition error) {
        if (error == null) {
            this.logger.debug("closing proton receiver for client [{}]", (Object)client.getName());
        } else {
            this.logger.debug("closing proton receiver for client [{}]: {}", (Object)client.getName(), (Object)error.getDescription());
        }
        client.close();
    }

    @Override
    public void onLinkAttach(ProtonConnection con, ProtonReceiver receiver, ResourceIdentifier targetResource) {
        this.logger.info("Endpoint [{}] does not support data upload, closing link.", (Object)this.getName());
        receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_IMPLEMENTED, (String)"resource cannot be written to"));
        receiver.close();
    }

    @Override
    public void onLinkAttach(ProtonConnection con, ProtonSender sender, ResourceIdentifier targetResource) {
        this.logger.info("Endpoint [{}] does not support data retrieval, closing link.", (Object)this.getName());
        sender.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_IMPLEMENTED, (String)"resource cannot be read from"));
        sender.close();
    }

    protected final void addHeadersToResponse(Message request, JsonObject message) {
        boolean isApplicationCorrelationId = MessageHelper.getXOptAppCorrelationId((Message)request);
        this.logger.debug("registration request [{}] uses application specific correlation ID: {}", request.getMessageId(), (Object)isApplicationCorrelationId);
        if (isApplicationCorrelationId) {
            message.put("x-opt-app-correlation-id", Boolean.valueOf(isApplicationCorrelationId));
        }
        JsonObject correlationIdJson = MessageHelper.encodeIdToJson((Object)this.getCorrelationId(request));
        message.put("correlation-id", correlationIdJson);
    }

    protected final Object getCorrelationId(Message request) {
        if (request.getCorrelationId() != null) {
            return request.getCorrelationId();
        }
        return request.getMessageId();
    }

    protected abstract boolean passesFormalVerification(ResourceIdentifier var1, Message var2);
}

