/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.client.RegistrationClient;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.auth.device.Device;
import org.eclipse.hono.service.auth.device.HonoClientBasedAuthProvider;
import org.eclipse.hono.util.MessageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T> {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    private HonoClient messaging;
    private HonoClient registration;
    private HonoClientBasedAuthProvider credentialsAuthProvider;

    @Autowired
    public void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Qualifier(value="messaging")
    @Autowired
    public final void setHonoMessagingClient(HonoClient honoClient) {
        this.messaging = Objects.requireNonNull(honoClient);
    }

    public final HonoClient getHonoMessagingClient() {
        return this.messaging;
    }

    @Qualifier(value="registration")
    @Autowired
    public final void setRegistrationServiceClient(HonoClient registrationServiceClient) {
        this.registration = Objects.requireNonNull(registrationServiceClient);
    }

    public final HonoClient getRegistrationServiceClient() {
        return this.registration;
    }

    @Autowired(required=false)
    public final void setCredentialsAuthProvider(HonoClientBasedAuthProvider credentialsAuthProvider) {
        this.credentialsAuthProvider = Objects.requireNonNull(credentialsAuthProvider);
    }

    protected abstract String getTypeName();

    public final HonoClientBasedAuthProvider getCredentialsAuthProvider() {
        return this.credentialsAuthProvider;
    }

    @Override
    protected final Future<Void> startInternal() {
        Future result = Future.future();
        if (StringUtils.isEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.messaging == null) {
            result.fail((Throwable)new IllegalStateException("Hono Messaging client must be set"));
        } else if (this.registration == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration client must be set"));
        } else if (this.credentialsAuthProvider == null) {
            result.fail((Throwable)new IllegalStateException("Credentials Authentication Provider must be set"));
        } else {
            this.connectToMessaging();
            this.connectToDeviceRegistration();
            this.credentialsAuthProvider.start().compose(s -> this.doStart((Future<Void>)result), result);
        }
        return result;
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    @Override
    protected final Future<Void> stopInternal() {
        this.LOG.info("stopping protocol adapter");
        Future result = Future.future();
        Future doStopResult = Future.future();
        this.doStop((Future<Void>)doStopResult);
        doStopResult.compose(s -> this.closeServiceClients()).recover(t -> {
            this.LOG.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).compose(s -> {
            result.complete();
            this.LOG.info("successfully stopped protocol adapter");
        }, result);
        return result;
    }

    private CompositeFuture closeServiceClients() {
        Future messagingTracker = Future.future();
        if (this.messaging == null) {
            messagingTracker.complete();
        } else {
            this.messaging.shutdown(messagingTracker.completer());
        }
        Future registrationTracker = Future.future();
        if (this.registration == null) {
            registrationTracker.complete();
        } else {
            this.registration.shutdown(registrationTracker.completer());
        }
        Future credentialsTracker = Future.future();
        if (this.credentialsAuthProvider == null) {
            credentialsTracker.complete();
        } else {
            credentialsTracker = this.credentialsAuthProvider.stop();
        }
        return CompositeFuture.all((Future)messagingTracker, (Future)registrationTracker, (Future)credentialsTracker);
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    protected final Future<HonoClient> connectToMessaging() {
        if (this.messaging == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("Hono Messaging client not set"));
        }
        return this.messaging.connect(this.createClientOptions(), this::onDisconnectMessaging).map(connectedClient -> {
            this.LOG.info("connected to Hono Messaging");
            return connectedClient;
        }).recover(t -> {
            this.LOG.warn("failed to connect to Hono Messaging", t);
            return Future.failedFuture((Throwable)t);
        });
    }

    private void onDisconnectMessaging(ProtonConnection con) {
        this.vertx.setTimer(500L, reconnect -> {
            this.LOG.info("attempting to reconnect to Hono Messaging");
            this.messaging.connect(this.createClientOptions(), this::onDisconnectMessaging).setHandler(connectAttempt -> {
                if (connectAttempt.succeeded()) {
                    this.LOG.info("reconnected to Hono Messaging");
                } else {
                    this.LOG.debug("cannot reconnect to Hono Messaging: {}", (Object)connectAttempt.cause().getMessage());
                }
            });
        });
    }

    protected final Future<HonoClient> connectToDeviceRegistration() {
        if (this.registration == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("Device Registration client not set"));
        }
        return this.registration.connect(this.createClientOptions(), this::onDisconnectDeviceRegistry).map(connectedClient -> {
            this.LOG.info("connected to Device Registration service");
            return connectedClient;
        }).recover(t -> {
            this.LOG.warn("failed to connect to Device Registration service", t);
            return Future.failedFuture((Throwable)t);
        });
    }

    private void onDisconnectDeviceRegistry(ProtonConnection con) {
        this.vertx.setTimer(500L, reconnect -> {
            this.LOG.info("attempting to reconnect to Device Registration service");
            this.registration.connect(this.createClientOptions(), this::onDisconnectDeviceRegistry).setHandler(connectAttempt -> {
                if (connectAttempt.succeeded()) {
                    this.LOG.info("reconnected to Device Registration service");
                } else {
                    this.LOG.debug("cannot reconnect to Device Registration service: {}", (Object)connectAttempt.cause().getMessage());
                }
            });
        });
    }

    private ProtonClientOptions createClientOptions() {
        return new ProtonClientOptions().setConnectTimeout(200).setReconnectAttempts(1).setReconnectInterval(500L);
    }

    protected final Future<Boolean> isConnected() {
        Future messagingCheck = Optional.ofNullable(this.messaging).map(client -> client.isConnected()).orElse(Future.succeededFuture((Object)Boolean.FALSE));
        Future registrationCheck = Optional.ofNullable(this.registration).map(client -> client.isConnected()).orElse(Future.succeededFuture((Object)Boolean.FALSE));
        return CompositeFuture.all((Future)messagingCheck, (Future)registrationCheck).compose(ok -> Future.succeededFuture((Object)((Boolean)messagingCheck.result() != false && (Boolean)registrationCheck.result() != false ? 1 : 0)));
    }

    protected final Future<MessageSender> getTelemetrySender(String tenantId) {
        return this.messaging.getOrCreateTelemetrySender(tenantId);
    }

    protected final Future<MessageSender> getEventSender(String tenantId) {
        return this.messaging.getOrCreateEventSender(tenantId);
    }

    protected final Future<RegistrationClient> getRegistrationClient(String tenantId) {
        return this.getRegistrationServiceClient().getOrCreateRegistrationClient(tenantId);
    }

    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result()));
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Future result = Future.future();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result;
    }

    protected final void addProperties(Message message, JsonObject registrationInfo) {
        JsonObject defaults;
        MessageHelper.addRegistrationAssertion((Message)message, (String)registrationInfo.getString("assertion"));
        MessageHelper.addProperty((Message)message, (String)"orig_adapter", (Object)this.getTypeName());
        if (((ProtocolAdapterProperties)this.getConfig()).isDefaultsEnabled() && (defaults = registrationInfo.getJsonObject("defaults")) != null) {
            this.addDefaults(message, defaults);
        }
        if (StringUtils.isEmpty((Object)message.getContentType())) {
            message.setContentType(CONTENT_TYPE_OCTET_STREAM);
        }
        if (((ProtocolAdapterProperties)this.getConfig()).isJmsVendorPropsEnabled()) {
            MessageHelper.addJmsVendorProperties((Message)message);
        }
    }

    private void addDefaults(Message message, JsonObject defaults) {
        defaults.forEach(prop -> {
            switch ((String)prop.getKey()) {
                case "content-type": {
                    if (!StringUtils.isEmpty((Object)message.getContentType()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentType((String)prop.getValue());
                    break;
                }
                case "content-encoding": {
                    if (!StringUtils.isEmpty((Object)message.getContentEncoding()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentEncoding((String)prop.getValue());
                    break;
                }
                case "absolute-expiry-time": 
                case "correlation-id": 
                case "creation-time": 
                case "group-id": 
                case "group-sequence": 
                case "message-id": 
                case "reply-to": 
                case "reply-to-group-id": 
                case "subject": 
                case "to": 
                case "user-id": {
                    this.LOG.debug("ignoring default property [{}] registered for device", prop.getKey());
                    break;
                }
                default: {
                    MessageHelper.addProperty((Message)message, (String)((String)prop.getKey()), prop.getValue());
                }
            }
        });
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        handler.register("connection-to-services", status -> this.isConnected().map(connected -> {
            if (connected.booleanValue()) {
                status.tryComplete((Object)Status.OK());
            } else {
                status.tryComplete((Object)Status.KO());
            }
            return null;
        }));
        if (this.credentialsAuthProvider != null) {
            this.credentialsAuthProvider.registerReadinessChecks(handler);
        }
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        if (this.credentialsAuthProvider != null) {
            this.credentialsAuthProvider.registerLivenessChecks(handler);
        }
    }

    protected final Message newMessage(String address, String deviceId, String publishAddress, String contentType, Buffer payload, JsonObject registrationInfo) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(registrationInfo);
        Message msg = ProtonHelper.message();
        msg.setAddress(address);
        MessageHelper.addDeviceId((Message)msg, (String)deviceId);
        if (publishAddress != null) {
            MessageHelper.addProperty((Message)msg, (String)"orig_address", (Object)publishAddress);
        }
        if (contentType != null) {
            msg.setContentType(contentType);
        }
        if (payload != null) {
            msg.setBody((Section)new Data(new Binary(payload.getBytes())));
        }
        this.addProperties(msg, registrationInfo);
        return msg;
    }
}

