/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import com.google.common.cache.CacheBuilder;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.metrics.MetricsOptions;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.connection.ConnectionFactory;
import org.eclipse.hono.connection.ConnectionFactoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.guava.GuavaCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public abstract class AbstractAdapterConfig {
    private MetricsOptions metricsOptions;

    @Autowired(required=false)
    public void setMetricsOptions(MetricsOptions metricsOptions) {
        this.metricsOptions = metricsOptions;
    }

    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(new AddressResolverOptions().setCacheNegativeTimeToLive(0).setCacheMaxTimeToLive(0).setQueryTimeout(1000L));
        if (this.metricsOptions != null) {
            options.setMetricsOptions(this.metricsOptions);
        }
        return Vertx.vertx((VertxOptions)options);
    }

    @Qualifier(value="messaging")
    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties messagingClientConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        this.customizeMessagingClientConfig(config);
        return config;
    }

    protected void customizeMessagingClientConfig(ClientConfigProperties config) {
    }

    @Qualifier(value="messaging")
    @Bean
    public ConnectionFactory messagingConnectionFactory() {
        return new ConnectionFactoryImpl(this.vertx(), this.messagingClientConfig());
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public HonoClient messagingClient() {
        return new HonoClientImpl(this.vertx(), this.messagingConnectionFactory(), this.messagingClientConfig());
    }

    @Qualifier(value="registration")
    @ConfigurationProperties(prefix="hono.registration")
    @Bean
    public RequestResponseClientConfigProperties registrationServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeRegistrationServiceClientConfig(config);
        return config;
    }

    protected void customizeRegistrationServiceClientConfig(RequestResponseClientConfigProperties config) {
    }

    @Qualifier(value="registration")
    @Bean
    public ConnectionFactory registrationServiceConnectionFactory() {
        return new ConnectionFactoryImpl(this.vertx(), (ClientConfigProperties)this.registrationServiceClientConfig());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public HonoClient registrationServiceClient() {
        HonoClientImpl result = new HonoClientImpl(this.vertx(), this.registrationServiceConnectionFactory(), (ClientConfigProperties)this.registrationServiceClientConfig());
        int minCacheSize = this.registrationServiceClientConfig().getResponseCacheMinSize();
        long maxCacheSize = this.registrationServiceClientConfig().getResponseCacheMaxSize();
        if (maxCacheSize > 0L) {
            result.setCacheManager(this.newCacheManager(minCacheSize, Math.max((long)minCacheSize, maxCacheSize)));
        }
        return result;
    }

    private CacheManager newCacheManager(int initialCapacity, long maxCapacity) {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(initialCapacity).maximumSize(maxCapacity);
        GuavaCacheManager manager = new GuavaCacheManager();
        manager.setAllowNullValues(false);
        manager.setCacheBuilder(builder);
        return manager;
    }

    @Qualifier(value="credentials")
    @ConfigurationProperties(prefix="hono.credentials")
    @Bean
    public ClientConfigProperties credentialsServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeCredentialsServiceClientConfig(config);
        return config;
    }

    protected void customizeCredentialsServiceClientConfig(RequestResponseClientConfigProperties config) {
    }

    @Qualifier(value="credentials")
    @Bean
    public ConnectionFactory credentialsServiceConnectionFactory() {
        return new ConnectionFactoryImpl(this.vertx(), this.credentialsServiceClientConfig());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public HonoClient credentialsServiceClient() {
        return new HonoClientImpl(this.vertx(), this.credentialsServiceConnectionFactory(), this.credentialsServiceClientConfig());
    }
}

