/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.base.jdbc.store.EntityNotFoundException;
import org.eclipse.hono.service.base.jdbc.store.OptimisticLockingException;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.device.AbstractDeviceStore;
import org.eclipse.hono.service.base.jdbc.store.device.CredentialsReadResult;
import org.eclipse.hono.service.base.jdbc.store.device.DeviceReadResult;
import org.eclipse.hono.service.base.jdbc.store.model.JdbcBasedDeviceDto;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.credentials.CredentialsDto;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceWithId;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableManagementStore
extends AbstractDeviceStore {
    private static final Logger log = LoggerFactory.getLogger(TableManagementStore.class);
    private static final String TENANT_ID = "tenant_id";
    private static final String DEVICE_ID = "device_id";
    private static final String VERSION = "version";
    private static final String DATA = "data";
    private static final String EXPECTED_VERSION = "expected_version";
    private static final String PAGE_SIZE = "page_size";
    private static final String PAGE_OFFSET = "page_offset";
    private static final String CREATED = "created";
    private static final String AUTO_PROVISIONED = "auto_provisioned";
    private static final String NEXT_VERSION = "next_version";
    private static final String FIELD = "field";
    private static final String VALUE = "value";
    private final Statement createStatement;
    private final Statement createMemberOfStatement;
    private final Statement deleteAllMemberOfStatement;
    private final Statement updateRegistrationVersionedStatement;
    private final Statement deleteStatement;
    private final Statement deleteVersionedStatement;
    private final Statement dropTenantStatement;
    private final Statement readForUpdateStatement;
    private final Statement readCredentialsStatement;
    private final Statement insertCredentialEntryStatement;
    private final Statement deleteAllCredentialsStatement;
    private final Statement updateDeviceVersionStatement;
    private final Statement countDevicesOfTenantStatement;
    private final Statement countDevicesWithFilterStatement;
    private final Statement countGatewaysOfTenantStatement;
    private final Statement countOnlyDevicesOfTenantStatement;
    private final Statement findDevicesOfTenantStatement;
    private final Statement findGatewaysOfTenantStatement;
    private final Statement findOnlyDevicesOfTenantStatement;
    private final Statement findDevicesOfTenantWithFilterStatement;

    public TableManagementStore(JDBCClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg);
        cfg.dump(log);
        this.createStatement = cfg.getRequiredStatement("create").validateParameters(TENANT_ID, DEVICE_ID, VERSION, DATA, CREATED, AUTO_PROVISIONED);
        this.createMemberOfStatement = cfg.getRequiredStatement("createMemberOf").validateParameters(TENANT_ID, DEVICE_ID, "group_id");
        this.deleteAllMemberOfStatement = cfg.getRequiredStatement("deleteAllMemberOf").validateParameters(TENANT_ID, DEVICE_ID);
        this.updateRegistrationVersionedStatement = cfg.getRequiredStatement("updateRegistrationVersioned").validateParameters(TENANT_ID, DEVICE_ID, NEXT_VERSION, DATA, EXPECTED_VERSION, "updated_on", "auto_provisioning_notification_sent");
        this.deleteStatement = cfg.getRequiredStatement("delete").validateParameters(TENANT_ID, DEVICE_ID);
        this.deleteVersionedStatement = cfg.getRequiredStatement("deleteVersioned").validateParameters(TENANT_ID, DEVICE_ID, EXPECTED_VERSION);
        this.dropTenantStatement = cfg.getRequiredStatement("dropTenant").validateParameters(TENANT_ID);
        this.readForUpdateStatement = cfg.getRequiredStatement("readForUpdate").validateParameters(TENANT_ID, DEVICE_ID);
        this.readCredentialsStatement = cfg.getRequiredStatement("readCredentials").validateParameters(TENANT_ID, DEVICE_ID);
        this.insertCredentialEntryStatement = cfg.getRequiredStatement("insertCredentialEntry").validateParameters(TENANT_ID, DEVICE_ID, "type", "auth_id", DATA);
        this.deleteAllCredentialsStatement = cfg.getRequiredStatement("deleteAllCredentials").validateParameters(TENANT_ID, DEVICE_ID);
        this.updateDeviceVersionStatement = cfg.getRequiredStatement("updateDeviceVersion").validateParameters(TENANT_ID, DEVICE_ID, NEXT_VERSION, EXPECTED_VERSION);
        this.countDevicesOfTenantStatement = cfg.getRequiredStatement("countDevicesOfTenant").validateParameters(TENANT_ID);
        this.countGatewaysOfTenantStatement = cfg.getRequiredStatement("countGatewaysOfTenant").validateParameters(TENANT_ID, DEVICE_ID);
        this.countOnlyDevicesOfTenantStatement = cfg.getRequiredStatement("countOnlyDevicesOfTenant").validateParameters(TENANT_ID, DEVICE_ID);
        this.countDevicesWithFilterStatement = cfg.getRequiredStatement("countDevicesOfTenantWithFilter").validateParameters(TENANT_ID, FIELD, VALUE);
        this.findDevicesOfTenantStatement = cfg.getRequiredStatement("findDevicesOfTenant").validateParameters(TENANT_ID, PAGE_SIZE, PAGE_OFFSET);
        this.findOnlyDevicesOfTenantStatement = cfg.getRequiredStatement("findOnlyDevicesOfTenant").validateParameters(TENANT_ID, DEVICE_ID, PAGE_SIZE, PAGE_OFFSET);
        this.findGatewaysOfTenantStatement = cfg.getRequiredStatement("findGatewaysOfTenant").validateParameters(TENANT_ID, DEVICE_ID, PAGE_SIZE, PAGE_OFFSET);
        this.findDevicesOfTenantWithFilterStatement = cfg.getRequiredStatement("findDevicesOfTenantWithFilter").validateParameters(TENANT_ID, FIELD, VALUE, PAGE_SIZE, PAGE_OFFSET);
    }

    protected Future<ResultSet> readDeviceForUpdate(SQLConnection connection, DeviceKey key, SpanContext span) {
        return this.read((SQLOperations)connection, key, Optional.empty(), this.readForUpdateStatement, span);
    }

    public Future<Versioned<Void>> createDevice(DeviceKey key, Device device, Tenant tenant, int globalDevicesPerTenantLimit, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"create device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forCreation(key, device, DeviceRegistryUtils.getUniqueIdentifier());
        return SQL.runTransactionally((SQLClient)this.client, this.tracer, span.context(), (connection, context) -> {
            Statement.ExpandedStatement expanded = this.createStatement.expand(params -> {
                params.put(TENANT_ID, deviceDto.getTenantId());
                params.put(DEVICE_ID, deviceDto.getDeviceId());
                params.put(VERSION, deviceDto.getVersion());
                params.put(DATA, deviceDto.getDeviceJson());
                params.put(CREATED, Timestamp.from(deviceDto.getCreationTime()));
                params.put(AUTO_PROVISIONED, deviceDto.isAutoProvisioned());
            });
            log.debug("createDevice - statement: {}", (Object)expanded);
            return this.getDeviceCount((SQLOperations)connection, key.getTenantId(), span.context(), this.countDevicesOfTenantStatement, null, null).compose(currentDeviceCount -> tenant.checkDeviceLimitReached(key.getTenantId(), (long)currentDeviceCount.intValue(), globalDevicesPerTenantLimit)).compose(ok -> expanded.trace(this.tracer, (SpanContext)context).update((SQLOperations)connection).recover(SQL::translateException)).compose(x -> this.createGroups((SQLConnection)connection, key, (Set<String>)new HashSet<String>(device.getMemberOf()), (SpanContext)context));
        }).map((Object)new Versioned(deviceDto.getVersion(), null)).onComplete(x -> span.finish());
    }

    private Future<Void> createGroups(SQLConnection connection, DeviceKey key, Set<String> memberOf, SpanContext context) {
        return Future.all(memberOf.stream().map(groupId -> {
            Statement.ExpandedStatement expanded = this.createMemberOfStatement.expand(params -> {
                params.put(TENANT_ID, key.getTenantId());
                params.put(DEVICE_ID, key.getDeviceId());
                params.put("group_id", groupId);
            });
            log.debug("addToGroup - statement: {}", (Object)expanded);
            return expanded.trace(this.tracer, context).update((SQLOperations)connection).recover(SQL::translateException);
        }).collect(Collectors.toList())).mapEmpty();
    }

    private Future<Void> deleteGroups(SQLConnection connection, DeviceKey key, SpanContext context) {
        Statement.ExpandedStatement expanded = this.deleteAllMemberOfStatement.expand(params -> {
            params.put(TENANT_ID, key.getTenantId());
            params.put(DEVICE_ID, key.getDeviceId());
        });
        log.debug("deleteGroups - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, context).update((SQLOperations)connection).recover(SQL::translateException).mapEmpty();
    }

    protected Future<UpdateResult> updateJsonField(DeviceKey key, Statement statement, String jsonValue, Optional<String> resourceVersion, String nextVersion, Span span) {
        Statement.ExpandedStatement expanded = statement.expand(map -> {
            map.put(TENANT_ID, key.getTenantId());
            map.put(DEVICE_ID, key.getDeviceId());
            map.put(NEXT_VERSION, nextVersion);
            map.put(DATA, jsonValue);
            resourceVersion.ifPresent(version -> map.put(EXPECTED_VERSION, version));
        });
        log.debug("update - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return this.checkOptimisticLock(result, span, resourceVersion, checkSpan -> this.readDevice((SQLOperations)this.client, key, (Span)checkSpan));
    }

    public Future<Versioned<Void>> updateDevice(DeviceKey key, Device device, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"update device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        resourceVersion.ifPresent(version -> span.setTag(VERSION, version));
        Set memberOf = Optional.ofNullable(device.getMemberOf()).map(HashSet::new).orElse(Collections.emptySet());
        JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forUpdate(key, device, DeviceRegistryUtils.getUniqueIdentifier());
        return SQL.runTransactionally((SQLClient)this.client, this.tracer, span.context(), (connection, context) -> this.readDeviceForUpdate((SQLConnection)connection, key, (SpanContext)context).compose(result -> TableManagementStore.extractVersionForUpdate(result, resourceVersion)).compose(version -> this.deleteGroups((SQLConnection)connection, key, (SpanContext)context).map(version)).compose(version -> this.createGroups((SQLConnection)connection, key, memberOf, (SpanContext)context).map(version)).compose(version -> this.updateRegistrationVersionedStatement.expand(map -> {
            map.put(TENANT_ID, deviceDto.getTenantId());
            map.put(DEVICE_ID, deviceDto.getDeviceId());
            map.put(DATA, deviceDto.getDeviceJson());
            map.put(EXPECTED_VERSION, version);
            map.put(NEXT_VERSION, deviceDto.getVersion());
            map.put("updated_on", Timestamp.from(deviceDto.getUpdatedOn()));
            map.put("auto_provisioning_notification_sent", deviceDto.isAutoProvisioningNotificationSent());
        }).trace(this.tracer, span.context()).update((SQLOperations)connection).compose(TableManagementStore::checkUpdateOutcome).map(version))).map(x -> new Versioned(deviceDto.getVersion(), null)).onComplete(x -> span.finish());
    }

    public Future<Optional<DeviceReadResult>> readDevice(DeviceKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        return this.readDevice((SQLOperations)this.client, key, span).flatMap(r -> {
            List entries = r.getRows(true);
            switch (entries.size()) {
                case 0: {
                    return Future.succeededFuture(Optional.empty());
                }
                case 1: {
                    JsonObject entry = (JsonObject)entries.get(0);
                    JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forRead(key.getTenantId(), key.getDeviceId(), entry);
                    return Future.succeededFuture(Optional.of(new DeviceReadResult(deviceDto.getDeviceWithStatus(), Optional.of(deviceDto.getVersion()))));
                }
            }
            return Future.failedFuture((Throwable)new IllegalStateException("Found multiple entries for a single device"));
        }).onComplete(x -> span.finish());
    }

    public Future<UpdateResult> deleteDevice(DeviceKey key, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"delete device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        resourceVersion.ifPresent(version -> span.setTag(VERSION, version));
        Statement statement = resourceVersion.isPresent() ? this.deleteVersionedStatement : this.deleteStatement;
        Statement.ExpandedStatement expanded = statement.expand(map -> {
            map.put(TENANT_ID, key.getTenantId());
            map.put(DEVICE_ID, key.getDeviceId());
            resourceVersion.ifPresent(version -> map.put(EXPECTED_VERSION, version));
        });
        log.debug("delete - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return this.checkOptimisticLock(result, span, resourceVersion, checkSpan -> this.readDevice((SQLOperations)this.client, key, (Span)checkSpan)).onComplete(x -> span.finish());
    }

    public Future<UpdateResult> dropTenant(String tenantId, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"drop tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        Statement.ExpandedStatement expanded = this.dropTenantStatement.expand(params -> params.put(TENANT_ID, tenantId));
        log.debug("delete - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client).onComplete(x -> span.finish());
    }

    public Future<Integer> getDeviceCount(SQLOperations operations, String tenantId, SpanContext spanContext, Statement countStatement, String field, String value) {
        Objects.requireNonNull(tenantId);
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"get device count", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        Statement.ExpandedStatement expanded = countStatement.expand(params -> {
            params.put(TENANT_ID, tenantId);
            params.put(FIELD, field);
            params.put(VALUE, value);
        });
        log.debug("count - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, span.context()).query(operations).map(r -> {
            List entries = r.getRows(true);
            switch (entries.size()) {
                case 1: {
                    Integer count = ((JsonObject)entries.get(0)).getInteger("DEVICECOUNT");
                    log.debug("found {} devices registered for tenant [tenant-id: {}]", (Object)count, (Object)tenantId);
                    return count;
                }
            }
            throw new IllegalStateException("Could not count devices of tenant");
        }).onComplete(x -> span.finish());
    }

    public Future<Versioned<Boolean>> setCredentials(DeviceKey key, List<CommonCredential> credentials, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"set credentials", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).withTag("num_credentials", (Number)credentials.size()).start();
        resourceVersion.ifPresent(version -> span.setTag(VERSION, version));
        String nextVersion = UUID.randomUUID().toString();
        return SQL.runTransactionally((SQLClient)this.client, this.tracer, span.context(), (connection, context) -> this.readDeviceForUpdate((SQLConnection)connection, key, (SpanContext)context).compose(result -> TableManagementStore.extractVersionForUpdate(result, resourceVersion)).compose(version -> Future.succeededFuture().compose(x -> {
            Promise result = Promise.promise();
            CredentialsDto updatedCredentialsDto = CredentialsDto.forUpdate((String)key.getTenantId(), (String)key.getDeviceId(), (List)credentials, (String)nextVersion);
            if (updatedCredentialsDto.requiresMerging()) {
                this.getCredentialsDto(key, (SQLConnection)connection, span).map(arg_0 -> ((CredentialsDto)updatedCredentialsDto).merge(arg_0)).onComplete((Handler)result);
            } else {
                result.complete((Object)updatedCredentialsDto);
            }
            return result.future();
        }).compose(updatedCredentials -> this.deleteAllCredentialsStatement.expand(map -> {
            map.put(TENANT_ID, key.getTenantId());
            map.put(DEVICE_ID, key.getDeviceId());
        }).trace(this.tracer, span.context()).update((SQLOperations)connection).map(updatedCredentials)).compose(updatedCredentials -> {
            updatedCredentials.createMissingSecretIds();
            return Future.all(updatedCredentials.getData().stream().map(JsonObject::mapFrom).filter(c -> c.containsKey("type") && c.containsKey("auth-id")).map(c -> this.insertCredentialEntryStatement.expand(map -> {
                map.put(TENANT_ID, key.getTenantId());
                map.put(DEVICE_ID, key.getDeviceId());
                map.put("type", c.getString("type"));
                map.put("auth_id", c.getString("auth-id"));
                map.put(DATA, c.toString());
            }).trace(this.tracer, span.context()).update((SQLOperations)connection)).collect(Collectors.toList())).mapEmpty();
        }).compose(x -> this.updateDeviceVersionStatement.expand(map -> {
            map.put(TENANT_ID, key.getTenantId());
            map.put(DEVICE_ID, key.getDeviceId());
            map.put(EXPECTED_VERSION, version);
            map.put(NEXT_VERSION, nextVersion);
        }).trace(this.tracer, span.context()).update((SQLOperations)connection).compose(TableManagementStore::checkUpdateOutcome)).map((Object)true))).recover(err -> this.recoverNotFound(span, (Throwable)err, () -> false)).map(ok -> new Versioned(nextVersion, ok)).onComplete(x -> span.finish());
    }

    private Future<CredentialsDto> getCredentialsDto(DeviceKey key, SQLConnection connection, Span span) {
        return this.readCredentialsStatement.expand(map -> {
            map.put(TENANT_ID, key.getTenantId());
            map.put(DEVICE_ID, key.getDeviceId());
        }).trace(this.tracer, span.context()).query((SQLOperations)connection).map(this::parseCredentials).map(existingCredentials -> CredentialsDto.forRead((String)key.getTenantId(), (String)key.getDeviceId(), (List)existingCredentials, null, null, null));
    }

    private <T> Future<T> recoverNotFound(Span span, Throwable err, Supplier<T> orProvider) {
        log.debug("Failed to update", err);
        if (SQL.hasCauseOf(err, EntityNotFoundException.class)) {
            TracingHelper.logError((Span)span, (String)"Entity not found");
            return Future.succeededFuture(orProvider.get());
        }
        return Future.failedFuture((Throwable)err);
    }

    private static Future<Object> checkUpdateOutcome(UpdateResult updateResult) {
        if (updateResult.getUpdated() < 0) {
            log.debug("Optimistic lock broke");
            return Future.failedFuture((Throwable)new OptimisticLockingException());
        }
        return Future.succeededFuture();
    }

    private static Future<String> extractVersionForUpdate(ResultSet device, Optional<String> resourceVersion) {
        Optional<String> version = device.getRows(true).stream().map(o -> o.getString(VERSION)).findAny();
        if (version.isEmpty()) {
            log.debug("No version or no row found -> entity not found");
            return Future.failedFuture((Throwable)new EntityNotFoundException());
        }
        String currentVersion = version.get();
        return resourceVersion.map(expected -> {
            if (expected.equals(currentVersion)) {
                return Future.succeededFuture((Object)currentVersion);
            }
            return Future.failedFuture((Throwable)new OptimisticLockingException());
        }).orElseGet(() -> Future.succeededFuture((Object)currentVersion));
    }

    public Future<Optional<CredentialsReadResult>> getCredentials(DeviceKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"get credentials", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        Statement.ExpandedStatement expanded = this.readCredentialsStatement.expand(map -> {
            map.put(TENANT_ID, key.getTenantId());
            map.put(DEVICE_ID, key.getDeviceId());
        });
        Promise promise = Promise.promise();
        this.client.getConnection((Handler)promise);
        return promise.future().compose(connection -> this.readDevice((SQLOperations)connection, key, span).compose(result -> TableManagementStore.extractVersionForUpdate(result, Optional.empty())).compose(version -> expanded.trace(this.tracer, span.context()).query((SQLOperations)connection).compose(r -> {
            span.log(Map.of("event", "read result", "rows", r.getNumRows()));
            List<CommonCredential> credentials = this.parseCredentials((ResultSet)r);
            log.debug("Credentials: {}", credentials);
            return Future.succeededFuture(Optional.of(new CredentialsReadResult(key.getDeviceId(), credentials, Optional.ofNullable(version))));
        })).onComplete(x -> connection.close())).recover(err -> this.recoverNotFound(span, (Throwable)err, Optional::empty)).onComplete(x -> span.finish());
    }

    private List<CommonCredential> parseCredentials(ResultSet result) {
        List entries = result.getRows(true);
        return entries.stream().map(o -> o.getString(DATA)).map(s -> (CommonCredential)Json.decodeValue((String)s, CommonCredential.class)).collect(Collectors.toList());
    }

    public Future<SearchResult<DeviceWithId>> findDevices(String tenantId, int pageSize, int pageOffset, List<Filter> filters, Optional<Boolean> isGateway, SpanContext spanContext) {
        Statement countStatement;
        Statement findDeviceSqlStatement;
        String value;
        String field;
        if (isGateway.isPresent()) {
            field = "";
            value = "";
            findDeviceSqlStatement = isGateway.get() != false ? this.findGatewaysOfTenantStatement : this.findOnlyDevicesOfTenantStatement;
            countStatement = isGateway.get() != false ? this.countGatewaysOfTenantStatement : this.countOnlyDevicesOfTenantStatement;
        } else {
            Optional filter = filters.stream().findFirst();
            field = filter.map(filter1 -> filter1.getField().toString().replace("/", "")).orElse("");
            value = filter.map(filter1 -> filter1.getValue().toString().replace("/", "").replace("*", "%").replace("?", "_")).orElse("");
            findDeviceSqlStatement = filter.isPresent() ? this.findDevicesOfTenantWithFilterStatement : this.findDevicesOfTenantStatement;
            countStatement = filter.isPresent() ? this.countDevicesWithFilterStatement : this.countDevicesOfTenantStatement;
        }
        Statement.ExpandedStatement expanded = findDeviceSqlStatement.expand(map -> {
            map.put(TENANT_ID, tenantId);
            map.put(PAGE_SIZE, pageSize);
            map.put(PAGE_OFFSET, pageOffset);
            map.put(FIELD, field);
            map.put(VALUE, value);
        });
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"find devices", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        Future<Integer> deviceCountFuture = this.getDeviceCount((SQLOperations)this.client, tenantId, span.context(), countStatement, field, value);
        return deviceCountFuture.compose(count -> expanded.trace(this.tracer, span.context()).query((SQLOperations)this.client)).map(r -> {
            if (r.getNumRows() == 0) {
                throw new ClientErrorException(tenantId, 404, "no devices matching searching criteria");
            }
            List entries = r.getRows(true);
            span.log(Map.of("event", "read result", "rows", entries.size()));
            ArrayList<DeviceWithId> list = new ArrayList<DeviceWithId>();
            for (JsonObject entry : entries) {
                String id = entry.getString(DEVICE_ID);
                JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forRead(tenantId, id, entry);
                list.add(DeviceWithId.from((String)id, (Device)deviceDto.getDeviceWithStatus()));
            }
            return new SearchResult(((Integer)deviceCountFuture.result()).intValue(), list);
        }).onComplete(x -> span.finish());
    }
}

