/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.vertx.core.Vertx;
import io.vertx.ext.jdbc.JDBCClient;
import java.security.Principal;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.eclipse.hono.service.base.jdbc.config.JdbcOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JdbcProperties {
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 15;
    public static final int DEFAULT_MINIMUM_POOL_SIZE = 3;
    public static final int DEFAULT_INITIAL_POOL_SIZE = 3;
    public static final int DEFAULT_MAXIMUM_IDLE_TIME = 3600;
    public static final int DEFAULT_MAXIMUM_CONNECTION_TIME = 30;
    public static final int DEFAULT_VALIDATION_TIME = 30;
    public static final int DEFAULT_LEAK_TIME = 60;
    private static final Logger log = LoggerFactory.getLogger(JdbcProperties.class);
    private String url;
    private String driverClass;
    private String username;
    private String password;
    private int maximumPoolSize = 15;
    private int minimumPoolSize = 3;
    private int initialPoolSize = 3;
    private int maximumIdleTime = 3600;
    private int maximumConnectionTime = 30;
    private int validationTime = 30;
    private int leakTime = 60;
    private String tableName;

    public JdbcProperties() {
    }

    public JdbcProperties(JdbcOptions options) {
        Objects.requireNonNull(options);
        this.setDriverClass(options.driverClass());
        this.setMaximumPoolSize(options.maximumPoolSize());
        this.setMinimumPoolSize(options.minimumPoolSize());
        this.setInitialPoolSize(options.initialPoolSize());
        this.setMaximumIdleTime(options.maximumIdleTime());
        this.setMaximumConnectionTime(options.maximumConnectionTime());
        this.setValidationTime(options.validationTime());
        this.setLeakTime(options.leakTime());
        options.password().ifPresent(this::setPassword);
        options.tableName().ifPresent(this::setTableName);
        this.setUrl(options.url());
        options.username().ifPresent(this::setUsername);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDriverClass(String driverClassName) {
        this.driverClass = driverClassName;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMinimumPoolSize(int minimumPoolSize) {
        this.minimumPoolSize = minimumPoolSize;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setMaximumIdleTime(int maximumIdleTime) {
        this.maximumIdleTime = maximumIdleTime;
    }

    public int getMaximumIdleTime() {
        return this.maximumIdleTime;
    }

    public void setMaximumConnectionTime(int maximumConnectionTime) {
        this.maximumConnectionTime = maximumConnectionTime;
    }

    public int getMaximumConnectionTime() {
        return this.maximumConnectionTime;
    }

    public void setValidationTime(int validationTime) {
        this.validationTime = validationTime;
    }

    public int getValidationTime() {
        return this.validationTime;
    }

    public void setLeakTime(int leakTime) {
        this.leakTime = leakTime;
    }

    public int getLeakTime() {
        return this.leakTime;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public static JDBCClient dataSource(Vertx vertx, JdbcProperties dataSourceProperties) {
        log.info("Creating new SQL client for table: {}", (Object)dataSourceProperties.getTableName());
        NamePrincipal username = Optional.ofNullable(dataSourceProperties.getUsername()).map(NamePrincipal::new).orElse(null);
        SimplePassword password = Optional.ofNullable(dataSourceProperties.getPassword()).map(SimplePassword::new).orElse(null);
        AgroalDataSourceConfigurationSupplier configuration = new AgroalDataSourceConfigurationSupplier().metricsEnabled(false).dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.AGROAL).connectionPoolConfiguration(poolConfig -> poolConfig.minSize(dataSourceProperties.getMinimumPoolSize()).maxSize(dataSourceProperties.getMaximumPoolSize()).initialSize(dataSourceProperties.getInitialPoolSize()).acquisitionTimeout(Duration.ofSeconds(dataSourceProperties.getMaximumConnectionTime())).validationTimeout(Duration.ofSeconds(dataSourceProperties.getValidationTime())).leakTimeout(Duration.ofSeconds(dataSourceProperties.getLeakTime())).reapTimeout(Duration.ofSeconds(dataSourceProperties.getMaximumIdleTime())).connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator()).connectionFactoryConfiguration(connConfig -> connConfig.jdbcUrl(dataSourceProperties.getUrl()).connectionProviderClassName(dataSourceProperties.getDriverClass()).principal((Principal)username).credential((Object)password)));
        return JDBCClient.create((Vertx)vertx, (DataSource)new io.agroal.pool.DataSource(configuration.get(), new AgroalDataSourceListener[0]));
    }
}

