/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.base.jdbc.store.EntityNotFoundException;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.tenant.AbstractTenantStore;
import org.eclipse.hono.service.base.jdbc.store.tenant.TenantReadResult;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantWithId;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementStore
extends AbstractTenantStore {
    private static final Logger log = LoggerFactory.getLogger(ManagementStore.class);
    private final String countStatementSql;
    private final Statement createStatement;
    private final Statement insertTrustAnchorStatement;
    private final Statement deleteAllTrustAnchorsStatement;
    private final Statement updateStatement;
    private final Statement updateVersionedStatement;
    private final Statement deleteStatement;
    private final Statement deleteVersionedStatement;
    private final Statement findTenantsStatement;

    public ManagementStore(JDBCClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg);
        this.countStatementSql = cfg.getRequiredStatement("count").expand().getSql();
        this.createStatement = cfg.getRequiredStatement("create").validateParameters("tenant_id", "version", "data");
        this.insertTrustAnchorStatement = cfg.getRequiredStatement("insertTrustAnchor").validateParameters("tenant_id", "subject_dn", "data");
        this.deleteAllTrustAnchorsStatement = cfg.getRequiredStatement("deleteAllTrustAnchors").validateParameters("tenant_id");
        this.updateStatement = cfg.getRequiredStatement("update").validateParameters("tenant_id", "next_version", "data");
        this.updateVersionedStatement = cfg.getRequiredStatement("updateVersioned").validateParameters("tenant_id", "next_version", "data", "expected_version");
        this.deleteStatement = cfg.getRequiredStatement("delete").validateParameters("tenant_id");
        this.deleteVersionedStatement = cfg.getRequiredStatement("deleteVersioned").validateParameters("tenant_id", "expected_version");
        this.findTenantsStatement = cfg.getRequiredStatement("findTenants").validateParameters("page_size", "page_offset");
    }

    public static StatementConfiguration defaultStatementConfiguration(String jdbcUrl, Optional<String> tenantTableName, Optional<String> trustAnchorsTenantName) throws IOException {
        String dialect = SQL.getDatabaseDialect(jdbcUrl);
        String tenantTableNameString = tenantTableName.orElse("tenants");
        String trustAnchorsTableNameString = trustAnchorsTenantName.orElse("tenant_trust_anchors");
        return StatementConfiguration.empty(tenantTableNameString, trustAnchorsTableNameString).overrideWithDefaultPattern("base", dialect, ManagementStore.class, StatementConfiguration.DEFAULT_PATH.resolve("tenant"));
    }

    private String tenantToJson(Tenant tenant) {
        JsonObject jsonObjectObj = JsonObject.mapFrom((Object)tenant);
        jsonObjectObj.remove("trusted-ca");
        return jsonObjectObj.toString();
    }

    public Future<Integer> getTenantCount() {
        Promise result = Promise.promise();
        this.client.querySingle(this.countStatementSql, rs -> {
            if (rs.failed()) {
                result.fail((Throwable)new IllegalStateException("failed to query number of tenants", rs.cause()));
            } else {
                result.complete((Object)((JsonArray)rs.result()).getInteger(0));
            }
        });
        return result.future();
    }

    public Future<Versioned<Void>> create(String tenantId, Tenant tenant, SpanContext spanContext) {
        String json = this.tenantToJson(tenant);
        String version = UUID.randomUUID().toString();
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"create tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        return SQL.runTransactionally((SQLClient)this.client, this.tracer, span.context(), (connection, context) -> {
            Statement.ExpandedStatement expanded = this.createStatement.expand(params -> {
                params.put("tenant_id", tenantId);
                params.put("version", version);
                params.put("data", json);
            });
            log.debug("create - statement: {}", (Object)expanded);
            return expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client).recover(SQL::translateException).flatMap(r -> this.insertAllTrustAnchors((SQLConnection)connection, tenantId, tenant, span));
        }).map((Object)new Versioned(version, null)).onComplete(x -> span.finish());
    }

    private Future<Void> deleteAllTrustAnchors(SQLConnection connection, String tenantId, Span span) {
        return this.deleteAllTrustAnchorsStatement.expand(params -> params.put("tenant_id", tenantId)).trace(this.tracer, span.context()).update((SQLOperations)connection).mapEmpty();
    }

    private Future<Void> insertAllTrustAnchors(SQLConnection connection, String tenantId, Tenant tenant, Span span) {
        if (tenant.getTrustedCertificateAuthorities() == null || tenant.getTrustedCertificateAuthorities().isEmpty()) {
            return Future.succeededFuture();
        }
        return CompositeFuture.all(tenant.getTrustedCertificateAuthorities().stream().map(anchor -> {
            JsonObject json = JsonObject.mapFrom((Object)anchor);
            Object subjectDn = json.remove("subject-dn");
            if (!(subjectDn instanceof String) || ((String)subjectDn).isEmpty()) {
                return Future.failedFuture((Throwable)new IllegalArgumentException(String.format("Missing field '%s' in trust anchor", "subject-dn")));
            }
            return this.insertTrustAnchorStatement.expand(params -> {
                params.put("tenant_id", tenantId);
                params.put("subject_dn", subjectDn);
                params.put("data", json.toString());
            }).trace(this.tracer, span.context()).update((SQLOperations)connection).recover(SQL::translateException);
        }).collect(Collectors.toList())).mapEmpty();
    }

    public Future<Optional<TenantReadResult>> read(String id, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"get tenant by id", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)id).start();
        return this.readTenant(id, span.context()).onComplete(x -> span.finish());
    }

    public Future<UpdateResult> delete(String tenantId, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"delete tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        resourceVersion.ifPresent(version -> span.setTag("version", version));
        Statement statement = resourceVersion.isPresent() ? this.deleteVersionedStatement : this.deleteStatement;
        Statement.ExpandedStatement expanded = statement.expand(map -> {
            map.put("tenant_id", tenantId);
            resourceVersion.ifPresent(version -> map.put("expected_version", version));
        });
        log.debug("delete - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return this.checkOptimisticLock(result, span, resourceVersion, checkSpan -> this.readTenantEntryById((SQLOperations)this.client, tenantId, checkSpan.context())).onComplete(x -> span.finish());
    }

    public Future<Versioned<Void>> update(String tenantId, Tenant tenant, Optional<String> resourceVersion, SpanContext spanContext) {
        String json = this.tenantToJson(tenant);
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"update tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        String nextVersion = UUID.randomUUID().toString();
        resourceVersion.ifPresent(version -> span.setTag("version", version));
        Statement statement = resourceVersion.isPresent() ? this.updateVersionedStatement : this.updateStatement;
        return SQL.runTransactionally((SQLClient)this.client, this.tracer, span.context(), (connection, context) -> this.updateJsonField((SQLOperations)connection, tenantId, statement, json, resourceVersion, nextVersion, span).flatMap(r -> {
            if (r.getUpdated() <= 0) {
                return Future.failedFuture((Throwable)new EntityNotFoundException());
            }
            return Future.succeededFuture();
        }).flatMap(x -> this.deleteAllTrustAnchors((SQLConnection)connection, tenantId, span)).flatMap(r -> this.insertAllTrustAnchors((SQLConnection)connection, tenantId, tenant, span))).map((Object)new Versioned(nextVersion, null)).onComplete(x -> span.finish());
    }

    protected Future<UpdateResult> updateJsonField(SQLOperations operations, String tenantId, Statement statement, String jsonValue, Optional<String> resourceVersion, String nextVersion, Span span) {
        Statement.ExpandedStatement expanded = statement.expand(map -> {
            map.put("tenant_id", tenantId);
            map.put("next_version", nextVersion);
            map.put("data", jsonValue);
            resourceVersion.ifPresent(version -> map.put("expected_version", version));
        });
        log.debug("update - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return this.checkOptimisticLock(result, span, resourceVersion, checkSpan -> this.readTenantEntryById((SQLOperations)this.client, tenantId, checkSpan.context()));
    }

    public Future<SearchResult<TenantWithId>> find(int pageSize, int pageOffset, SpanContext spanContext) {
        Statement.ExpandedStatement expanded = this.findTenantsStatement.expand(map -> {
            map.put("page_size", pageSize);
            map.put("page_offset", pageOffset);
        });
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"find tenants", (String)this.getClass().getSimpleName()).start();
        Future<Integer> tenantCountFuture = this.getTenantCount();
        return tenantCountFuture.compose(count -> expanded.trace(this.tracer, span.context()).query((SQLOperations)this.client)).map(r -> {
            if (r.getNumRows() == 0) {
                throw new ClientErrorException(404, "no tenants found");
            }
            List entries = r.getRows(true);
            span.log(Map.of("event", "read result", "rows", entries.size()));
            ArrayList<TenantWithId> list = new ArrayList<TenantWithId>();
            for (JsonObject entry : entries) {
                String id = entry.getString("tenant_id");
                Tenant tenant = (Tenant)Json.decodeValue((String)entry.getString("data"), Tenant.class);
                list.add(TenantWithId.from((String)id, (Tenant)tenant));
            }
            return new SearchResult(((Integer)tenantCountFuture.result()).intValue(), list);
        }).onComplete(x -> span.finish());
    }
}

