/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.tenant;

import io.opentracing.Tracer;
import io.vertx.core.Vertx;
import io.vertx.ext.jdbc.JDBCClient;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.hono.service.base.jdbc.config.JdbcProperties;
import org.eclipse.hono.service.base.jdbc.store.tenant.AdapterStore;
import org.eclipse.hono.service.base.jdbc.store.tenant.ManagementStore;

public final class Stores {
    private Stores() {
    }

    public static AdapterStore adapterStore(Vertx vertx, Tracer tracer, JdbcProperties properties) throws IOException {
        JDBCClient client = JdbcProperties.dataSource(vertx, properties);
        String jdbcUrl = properties.getUrl();
        return new AdapterStore(client, tracer, AdapterStore.defaultStatementConfiguration(jdbcUrl, Optional.ofNullable(properties.getTableName()), Optional.ofNullable(properties.getTableName()).map(name -> name + "_trust_anchors")));
    }

    public static ManagementStore managementStore(Vertx vertx, Tracer tracer, JdbcProperties properties) throws IOException {
        JDBCClient client = JdbcProperties.dataSource(vertx, properties);
        String jdbcUrl = properties.getUrl();
        return new ManagementStore(client, tracer, ManagementStore.defaultStatementConfiguration(jdbcUrl, Optional.ofNullable(properties.getTableName()), Optional.ofNullable(properties.getTableName()).map(name -> name + "_trust_anchors")));
    }
}

