/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.Future;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLOperations;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.service.base.jdbc.store.AbstractStore;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.tenant.TenantReadResult;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TrustedCertificateAuthority;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenantStore
extends AbstractStore {
    public static final String DEFAULT_TENANTS_TABLE_NAME = "tenants";
    public static final String DEFAULT_TRUST_ANCHORS_NAME = "tenant_trust_anchors";
    private static final Logger log = LoggerFactory.getLogger(AbstractTenantStore.class);
    protected final JDBCClient client;
    protected final Tracer tracer;
    private final Statement readStatement;
    private final Statement readTrustAnchorsStatement;

    public AbstractTenantStore(JDBCClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg.getStatement("checkConnection"));
        cfg.dump(log);
        this.client = client;
        this.tracer = tracer;
        this.readStatement = cfg.getRequiredStatement("read").validateParameters("tenant_id");
        this.readTrustAnchorsStatement = cfg.getRequiredStatement("readTrustAnchors").validateParameters("tenant_id");
    }

    public Future<Optional<TenantReadResult>> readTenant(String id, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)id).start();
        Statement.ExpandedStatement expanded = this.readStatement.expand(map -> map.put("tenant_id", id));
        return SQL.runTransactionally((SQLClient)this.client, this.tracer, span.context(), (connection, context) -> this.readTenantBy((SQLOperations)connection, expanded, (SpanContext)context)).onComplete(x -> span.finish());
    }

    protected Future<Optional<TenantReadResult>> readTenantBy(SQLOperations operations, Statement.ExpandedStatement expanded, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read tenant by", (String)this.getClass().getSimpleName()).start();
        return expanded.trace(this.tracer, span.context()).query(operations).flatMap(r -> {
            List entries = r.getRows(true);
            span.log(Map.of("event", "read result", "rows", entries.size()));
            switch (entries.size()) {
                case 0: {
                    return Future.succeededFuture(Optional.empty());
                }
                case 1: {
                    return Future.succeededFuture((Object)((JsonObject)entries.get(0))).map(entry -> {
                        String id = entry.getString("tenant_id");
                        Tenant tenant = (Tenant)Json.decodeValue((String)entry.getString("data"), Tenant.class);
                        Optional<String> version = Optional.ofNullable(entry.getString("version"));
                        return Optional.of(new TenantReadResult(id, tenant, version));
                    });
                }
            }
            return Future.failedFuture((Throwable)new IllegalStateException("Found multiple entries for a single tenant"));
        }).flatMap(result -> {
            if (result.isPresent()) {
                return this.fillTrustAnchors(operations, (TenantReadResult)result.get(), span.context()).map(Optional::ofNullable);
            }
            return Future.succeededFuture((Object)result);
        }).onComplete(x -> span.finish());
    }

    protected Future<ResultSet> readTenantEntryById(SQLOperations operations, String id, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read tenant entry", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)id).start();
        Statement.ExpandedStatement expanded = this.readStatement.expand(map -> map.put("tenant_id", id));
        return expanded.trace(this.tracer, span.context()).query(operations).onComplete(x -> span.finish());
    }

    protected Future<ResultSet> readTenantTrustAnchors(SQLOperations operations, String id, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"populate trust anchors", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)id).start();
        Statement.ExpandedStatement expanded = this.readTrustAnchorsStatement.expand(map -> map.put("tenant_id", id));
        log.debug("readTenantTrustAnchors - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, span.context()).query(operations).onComplete(x -> span.finish());
    }

    protected Future<TenantReadResult> fillTrustAnchors(SQLOperations operations, TenantReadResult tenant, SpanContext spanContext) {
        return this.readTenantTrustAnchors(operations, tenant.getId(), spanContext).map(result -> {
            tenant.getTenant().setTrustedCertificateAuthorities(this.convertTrustAnchors((ResultSet)result));
            return tenant;
        });
    }

    protected List<TrustedCertificateAuthority> convertTrustAnchors(ResultSet result) {
        return result.getRows(true).stream().map(this::convertTrustAnchor).collect(Collectors.toList());
    }

    protected TrustedCertificateAuthority convertTrustAnchor(JsonObject row) {
        String subjectDn = row.getString("subject_dn");
        TrustedCertificateAuthority result = (TrustedCertificateAuthority)Json.decodeValue((String)row.getString("data"), TrustedCertificateAuthority.class);
        result.setSubjectDn(subjectDn);
        return result;
    }
}

