/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOperations;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.service.base.jdbc.store.AbstractStore;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeviceStore
extends AbstractStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractDeviceStore.class);
    protected final JDBCClient client;
    protected final Tracer tracer;
    private final Statement readRegistrationStatement;

    public AbstractDeviceStore(JDBCClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg.getStatement("checkConnection"));
        this.client = client;
        this.tracer = tracer;
        this.readRegistrationStatement = cfg.getRequiredStatement("readRegistration").validateParameters("tenant_id", "device_id");
    }

    protected Future<ResultSet> readDevice(SQLOperations operations, DeviceKey key, Span span) {
        return this.read(operations, key, this.readRegistrationStatement, span.context());
    }

    protected Future<ResultSet> read(SQLOperations operations, DeviceKey key, Statement statement, SpanContext spanContext) {
        return this.read(operations, key, Optional.empty(), statement, spanContext);
    }

    protected Future<ResultSet> read(SQLOperations operations, DeviceKey key, Optional<String> resourceVersion, Statement statement, SpanContext spanContext) {
        Statement.ExpandedStatement expanded = statement.expand(params -> {
            params.put("tenant_id", key.getTenantId());
            params.put("device_id", key.getDeviceId());
            resourceVersion.ifPresent(version -> params.put("expected_version", version));
        });
        log.debug("read - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, spanContext).query((SQLOperations)this.client);
    }
}

