/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class StatementConfiguration {
    public static final Path DEFAULT_PATH = Paths.get("/etc/config/sql", new String[0]);
    private static final boolean SKIP_DUMPING_CONFIG = Boolean.getBoolean("org.eclipse.hono.service.base.jdbc.store.skipDumpingStatementConfiguration");
    private static final Logger log = LoggerFactory.getLogger(StatementConfiguration.class);
    private final Map<String, Statement> statements;
    private final Object[] formatArguments;

    private StatementConfiguration(Map<String, Statement> statements, Object[] formatArguments) {
        this.statements = statements;
        this.formatArguments = formatArguments;
    }

    public StatementConfiguration overrideWith(Path path, boolean ignoreMissing) throws IOException {
        if (ignoreMissing && !Files.exists(path, new LinkOption[0])) {
            log.info("Ignoring missing statement configuration file: {}", (Object)path);
            return this;
        }
        log.info("Loading statement configuration file: {}", (Object)path);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StatementConfiguration statementConfiguration = this.overrideWith(input, false);
            return statementConfiguration;
        }
    }

    public StatementConfiguration overrideWith(InputStream input, boolean ignoreMissing) {
        if (input == null) {
            if (ignoreMissing) {
                return this;
            }
            throw new IllegalArgumentException("Missing input");
        }
        Yaml yaml = StatementConfiguration.createYamlParser();
        Map properties = (Map)yaml.load(input);
        if (properties == null) {
            return this;
        }
        return this.overrideWith(properties);
    }

    private StatementConfiguration overrideWith(Map<String, Object> properties) {
        HashMap<String, Statement> result = new HashMap<String, Statement>(this.statements);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String value;
            if (entry.getKey() == null) continue;
            String key = entry.getKey();
            if (entry.getValue() != null && !(entry.getValue() instanceof String)) {
                throw new IllegalArgumentException(String.format("Key '%s' is not of type string: %s", entry.getKey(), entry.getValue().getClass()));
            }
            String string = value = entry.getValue() != null ? entry.getValue().toString() : null;
            if (value == null || value.isBlank()) {
                result.remove(key);
                continue;
            }
            Statement s = Statement.statement(value, this.formatArguments);
            result.put(key, s);
        }
        return new StatementConfiguration(result, this.formatArguments);
    }

    public Optional<Statement> getStatement(String key) {
        return Optional.ofNullable(this.statements.get(key));
    }

    public Statement getRequiredStatement(String key) {
        return this.getStatement(key).orElseThrow(() -> new IllegalArgumentException(String.format("Statement with key '%s' not found", key)));
    }

    public static StatementConfiguration empty(Object ... formatArguments) {
        return new StatementConfiguration(Collections.emptyMap(), formatArguments);
    }

    public StatementConfiguration overrideWithDefaultPattern(String basename, String dialect, Class<?> clazz, Path path) throws IOException {
        String base = basename + ".sql.yaml";
        String dialected = basename + "." + dialect + ".sql.yaml";
        try (InputStream resource = clazz.getResourceAsStream(base);){
            StatementConfiguration statementConfiguration;
            block12: {
                InputStream dialectResource = clazz.getResourceAsStream(dialected);
                try {
                    Path overridePath = path.resolve(basename + ".sql.yaml");
                    log.info("Loading - class: {}, name: {}, input: {}", new Object[]{clazz, base, resource});
                    log.info("Loading - class: {}, name: {}, input: {}", new Object[]{clazz, dialected, dialectResource});
                    log.info("Loading - path: {}", (Object)overridePath);
                    statementConfiguration = this.overrideWith(resource, false).overrideWith(dialectResource, true).overrideWith(overridePath, true);
                    if (dialectResource == null) break block12;
                }
                catch (Throwable throwable) {
                    if (dialectResource != null) {
                        try {
                            dialectResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dialectResource.close();
            }
            return statementConfiguration;
        }
    }

    public void dump(Logger logger) {
        if (SKIP_DUMPING_CONFIG) {
            return;
        }
        if (!logger.isInfoEnabled()) {
            return;
        }
        StringBuilder b = new StringBuilder("Dumping statement configuration").append(System.lineSeparator());
        b.append(String.format("Format arguments: %s", this.formatArguments)).append(System.lineSeparator());
        b.append("Statements:").append(System.lineSeparator());
        Object[] keys = (String[])this.statements.keySet().toArray(String[]::new);
        Arrays.sort(keys);
        b.append(Arrays.stream(keys).map(key -> String.format("name: %s%s%s%s", System.lineSeparator(), key, System.lineSeparator(), this.statements.get(key))).collect(Collectors.joining(System.lineSeparator())));
        logger.info(b.toString());
    }

    static Yaml createYamlParser() {
        return new Yaml((BaseConstructor)new Constructor(){

            protected Class<?> getClassForName(String name) throws ClassNotFoundException {
                throw new IllegalArgumentException("Class instantiation is not supported");
            }
        });
    }
}

