/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.devcon;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.service.deviceconnection.DeviceConnectionKey;
import org.eclipse.hono.service.base.jdbc.store.AbstractStore;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.devcon.DeviceState;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Store
extends AbstractStore {
    public static final String DEFAULT_TABLE_NAME = "device_states";
    private static final Logger log = LoggerFactory.getLogger(Store.class);
    private final SQLClient client;
    private final Tracer tracer;
    private final Statement readStatement;
    private final Statement updateStatement;
    private final Statement dropTenantStatement;

    public Store(SQLClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg.getStatement("checkConnection"));
        cfg.dump(log);
        this.client = client;
        this.tracer = tracer;
        this.readStatement = cfg.getRequiredStatement("read").validateParameters("tenant_id", "device_id");
        this.updateStatement = cfg.getRequiredStatement("update").validateParameters("tenant_id", "device_id", "gateway_id");
        this.dropTenantStatement = cfg.getRequiredStatement("dropTenant").validateParameters("tenant_id");
    }

    public static StatementConfiguration defaultStatementConfiguration(String jdbcUrl, Optional<String> tableName) throws IOException {
        String dialect = SQL.getDatabaseDialect(jdbcUrl);
        String tableNameString = tableName.orElse(DEFAULT_TABLE_NAME);
        return StatementConfiguration.empty(tableNameString).overrideWithDefaultPattern("base", dialect, Store.class, StatementConfiguration.DEFAULT_PATH.resolve("devcon"));
    }

    public Future<Optional<DeviceState>> readDeviceState(DeviceConnectionKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read device state", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        Statement.ExpandedStatement expanded = this.readStatement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
        });
        log.debug("readDeviceState - statement: {}", (Object)expanded);
        Future<ResultSet> result = expanded.trace(this.tracer, span.context()).query((SQLOperations)this.client);
        Future f = result.flatMap(r -> {
            List entries = r.getRows(true);
            span.log(Map.of("event", "read result", "rows", entries.size()));
            switch (entries.size()) {
                case 0: {
                    return Future.succeededFuture(Optional.empty());
                }
                case 1: {
                    JsonObject entry = (JsonObject)entries.get(0);
                    DeviceState state = new DeviceState();
                    state.setLastKnownGateway(Optional.ofNullable(entry.getString("last_known_gateway")));
                    return Future.succeededFuture(Optional.of(state));
                }
            }
            return Future.failedFuture((Throwable)new IllegalStateException("Found multiple entries for a single device"));
        });
        return f.onComplete(x -> span.finish());
    }

    public Future<UpdateResult> setLastKnownGateway(DeviceConnectionKey key, String gatewayId, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"update device state", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).withTag((Tag)TracingHelper.TAG_GATEWAY_ID, (Object)gatewayId).start();
        Statement.ExpandedStatement expanded = this.updateStatement.expand(params -> {
            params.put("tenant_id", key.getTenantId());
            params.put("device_id", key.getDeviceId());
            params.put("gateway_id", gatewayId);
        });
        log.debug("setLastKnownGateway - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return result.onComplete(x -> span.finish());
    }

    public Future<UpdateResult> dropTenant(String tenantId, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"drop tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        Statement.ExpandedStatement expanded = this.dropTenantStatement.expand(params -> params.put("tenant_id", tenantId));
        log.debug("dropTenant - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return result.onComplete(x -> span.finish());
    }
}

