/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.device;

import io.opentracing.Tracer;
import io.vertx.core.Vertx;
import io.vertx.ext.sql.SQLClient;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.service.base.jdbc.config.JdbcDeviceStoreProperties;
import org.eclipse.hono.service.base.jdbc.config.JdbcProperties;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.device.AbstractDeviceStore;
import org.eclipse.hono.service.base.jdbc.store.device.Configurations;
import org.eclipse.hono.service.base.jdbc.store.device.TableAdapterStore;
import org.eclipse.hono.service.base.jdbc.store.device.TableManagementStore;

public final class DeviceStores {
    private DeviceStores() {
    }

    public static StoreFactory<TableAdapterStore> adapterStoreFactory() {
        return AdapterStoreFactory.INSTANCE;
    }

    public static StoreFactory<TableManagementStore> managementStoreFactory() {
        return ManagementStoreFactory.INSTANCE;
    }

    public static <T extends AbstractDeviceStore> T store(Vertx vertx, Tracer tracer, JdbcDeviceStoreProperties deviceProperties, Function<JdbcDeviceStoreProperties, JdbcProperties> extractor, StoreFactory<T> factory) throws IOException {
        JdbcProperties properties = extractor.apply(deviceProperties);
        Optional<String> prefix = Optional.ofNullable(properties.getTableName());
        Optional<String> credentials = prefix.map(s -> s + "_credentials");
        Optional<String> registrations = prefix.map(s -> s + "_registrations");
        Optional<String> groups = prefix.map(s -> s + "_groups");
        return factory.createTable(vertx, tracer, properties, credentials, registrations, groups);
    }

    private static final class ManagementStoreFactory
    implements StoreFactory<TableManagementStore> {
        private static final StoreFactory<TableManagementStore> INSTANCE = new ManagementStoreFactory();

        private ManagementStoreFactory() {
        }

        @Override
        public TableManagementStore createTable(Vertx vertx, Tracer tracer, JdbcProperties properties, Optional<String> credentials, Optional<String> registrations, Optional<String> groups) throws IOException {
            return new TableManagementStore((SQLClient)JdbcProperties.dataSource(vertx, properties), tracer, Configurations.tableConfiguration(properties.getUrl(), credentials, registrations, groups));
        }
    }

    private static final class AdapterStoreFactory
    implements StoreFactory<TableAdapterStore> {
        private static final StoreFactory<TableAdapterStore> INSTANCE = new AdapterStoreFactory();

        private AdapterStoreFactory() {
        }

        @Override
        public TableAdapterStore createTable(Vertx vertx, Tracer tracer, JdbcProperties properties, Optional<String> credentials, Optional<String> registrations, Optional<String> groups) throws IOException {
            return new TableAdapterStore((SQLClient)JdbcProperties.dataSource(vertx, properties), tracer, Configurations.tableConfiguration(properties.getUrl(), credentials, registrations, groups), SQL.getDatabaseDialect(properties.getUrl()));
        }
    }

    public static interface StoreFactory<T extends AbstractDeviceStore> {
        public T createTable(Vertx var1, Tracer var2, JdbcProperties var3, Optional<String> var4, Optional<String> var5, Optional<String> var6) throws IOException;
    }
}

