/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.model;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceDto;
import org.eclipse.hono.service.management.device.DeviceStatus;

public class JdbcBasedDeviceDto
extends DeviceDto {
    public static JdbcBasedDeviceDto forCreation(DeviceKey deviceKey, Boolean autoProvisioned, Device device) {
        return (JdbcBasedDeviceDto)DeviceDto.forCreation(JdbcBasedDeviceDto::new, (String)deviceKey.getTenantId(), (String)deviceKey.getDeviceId(), (Boolean)autoProvisioned, (Device)device, (String)UUID.randomUUID().toString());
    }

    public static JdbcBasedDeviceDto forRead(String tenantId, String deviceId, JsonObject recordJson) {
        return (JdbcBasedDeviceDto)DeviceDto.forRead(JdbcBasedDeviceDto::new, (String)tenantId, (String)deviceId, (Device)((Device)Json.decodeValue((String)recordJson.getString("data"), Device.class)), (DeviceStatus)new DeviceStatus().setAutoProvisioned(recordJson.getBoolean("auto_provisioned")).setAutoProvisioningNotificationSent(recordJson.getBoolean("auto_provisioning_notification_sent")), (Instant)recordJson.getInstant("created"), (Instant)recordJson.getInstant("updated_on"), (String)Optional.ofNullable(recordJson.getString("version")).orElse(null));
    }

    public static JdbcBasedDeviceDto forUpdate(DeviceKey deviceKey, Boolean autoProvisioningNotificationSent, Device device) {
        return (JdbcBasedDeviceDto)DeviceDto.forUpdate(JdbcBasedDeviceDto::new, (String)deviceKey.getTenantId(), (String)deviceKey.getDeviceId(), (Boolean)autoProvisioningNotificationSent, (Device)JdbcBasedDeviceDto.withoutStatus((Device)device), (String)UUID.randomUUID().toString());
    }

    public String getDeviceJson() {
        return Json.encode((Object)this.getData());
    }
}

