/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JdbcProperties {
    private static final Logger log = LoggerFactory.getLogger(JdbcProperties.class);
    private String url;
    private String driverClass;
    private String username;
    private String password;
    private Integer maximumPoolSize;
    private String tableName;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDriverClass(String driverClassName) {
        this.driverClass = driverClassName;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public static JDBCClient dataSource(Vertx vertx, JdbcProperties dataSourceProperties) {
        JsonObject config = new JsonObject().put("url", dataSourceProperties.getUrl()).put("user", dataSourceProperties.getUsername());
        if (dataSourceProperties.getDriverClass() != null) {
            config.put("driver_class", dataSourceProperties.getDriverClass());
        }
        if (dataSourceProperties.getMaximumPoolSize() != null) {
            config.put("max_pool_size", dataSourceProperties.getMaximumPoolSize());
        }
        log.info("Creating new SQL client: {} - table: {}", (Object)config, (Object)dataSourceProperties.getTableName());
        config.put("password", dataSourceProperties.getPassword());
        return JDBCClient.create((Vertx)vertx, (JsonObject)config);
    }
}

