/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.Future;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLOperations;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.hono.deviceregistry.service.credentials.CredentialKey;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.device.AbstractDeviceStore;
import org.eclipse.hono.service.base.jdbc.store.device.CredentialsReadResult;
import org.eclipse.hono.service.base.jdbc.store.device.DeviceReadResult;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAdapterStore
extends AbstractDeviceStore {
    private static final Logger log = LoggerFactory.getLogger(TableAdapterStore.class);
    private final Statement findCredentialsStatement;
    private final Statement resolveGroupsStatement;

    public TableAdapterStore(SQLClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg);
        cfg.dump(log);
        this.findCredentialsStatement = cfg.getRequiredStatement("findCredentials").validateParameters("tenant_id", "type", "auth_id");
        this.resolveGroupsStatement = cfg.getRequiredStatement("resolveGroups").validateParameters("tenant_id", "group_ids");
    }

    protected Future<ResultSet> readDevice(DeviceKey key, Span span) {
        return this.readDevice((SQLOperations)this.client, key, span);
    }

    public Future<Optional<DeviceReadResult>> readDevice(DeviceKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        return this.readDevice((SQLOperations)this.client, key, span).flatMap(r -> {
            List entries = r.getRows(true);
            switch (entries.size()) {
                case 0: {
                    return Future.succeededFuture(Optional.empty());
                }
                case 1: {
                    JsonObject entry = (JsonObject)entries.get(0);
                    Device device = (Device)Json.decodeValue((String)entry.getString("data"), Device.class);
                    Optional<String> version = Optional.ofNullable(entry.getString("version"));
                    return Future.succeededFuture(Optional.of(new DeviceReadResult(device, version)));
                }
            }
            return Future.failedFuture((Throwable)new IllegalStateException("Found multiple entries for a single device"));
        }).onComplete(x -> span.finish());
    }

    public Future<Optional<CredentialsReadResult>> findCredentials(CredentialKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"find credentials", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_AUTH_ID, (Object)key.getAuthId()).withTag((Tag)TracingHelper.TAG_CREDENTIALS_TYPE, (Object)key.getType()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).start();
        Statement.ExpandedStatement expanded = this.findCredentialsStatement.expand(params -> {
            params.put("tenant_id", key.getTenantId());
            params.put("type", key.getType());
            params.put("auth_id", key.getAuthId());
        });
        log.debug("findCredentials - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, span.context()).query((SQLOperations)this.client).flatMap(r -> {
            List entries = r.getRows(true);
            span.log(Map.of("event", "read result", "rows", entries.size()));
            Set deviceIds = entries.stream().map(o -> o.getString("device_id")).filter(Objects::nonNull).collect(Collectors.toSet());
            int num = deviceIds.size();
            if (num <= 0) {
                return Future.succeededFuture(Optional.empty());
            }
            if (num > 1) {
                TracingHelper.logError((Span)span, (String)"Found multiple entries for a single device");
                return Future.failedFuture((Throwable)new IllegalStateException("Found multiple entries for a single device"));
            }
            String deviceId = (String)deviceIds.iterator().next();
            List<CommonCredential> credentials = entries.stream().map(o -> o.getString("data")).map(s -> (CommonCredential)Json.decodeValue((String)s, CommonCredential.class)).collect(Collectors.toList());
            return Future.succeededFuture(Optional.of(new CredentialsReadResult(deviceId, credentials, Optional.empty())));
        }).onComplete(x -> span.finish());
    }

    public Future<Set<String>> resolveGroupMembers(String tenantId, Set<String> viaGroups, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"resolve group members", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag("via_groups", String.join((CharSequence)", ", viaGroups)).start();
        Statement.ExpandedStatement expanded = this.resolveGroupsStatement.expand(params -> {
            params.put("tenant_id", tenantId);
            params.put("group_ids", viaGroups.toArray(String[]::new));
        });
        log.debug("resolveGroupMembers - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, span.context()).query((SQLOperations)this.client).flatMap(r -> {
            List entries = r.getRows(true);
            span.log(Map.of("event", "read result", "rows", entries.size()));
            return Future.succeededFuture(entries.stream().map(o -> o.getString("device_id")).filter(Objects::nonNull).collect(Collectors.toSet()));
        }).onComplete(x -> span.finish());
    }
}

