/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store;

import com.google.common.base.MoreObjects;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hono.service.base.jdbc.store.SQL;

public final class Statement {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("(?<pre>^|[^\\:]):(?<name>[a-zA-Z_]+)");
    private static final Object NOT_FOUND_MARKER = new Object();
    private final String sql;
    private final List<Map.Entry<String, Integer>> mappings;

    private Statement(String sql, List<Map.Entry<String, Integer>> mappings) {
        Objects.requireNonNull(sql);
        Objects.requireNonNull(mappings);
        this.sql = sql;
        this.mappings = mappings;
    }

    public Statement validateParameters(String ... availableParameters) {
        if (availableParameters == null || availableParameters.length <= 0) {
            return this;
        }
        Arrays.sort(availableParameters);
        HashSet<String> missingKeys = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : this.mappings) {
            if (Arrays.binarySearch(availableParameters, entry.getKey()) >= 0) continue;
            missingKeys.add(entry.getKey());
        }
        if (!missingKeys.isEmpty()) {
            Object[] keys = (String[])missingKeys.toArray(String[]::new);
            Arrays.sort(keys);
            throw new IllegalStateException(String.format("Statement uses keys which are not available - missing: %s, available: %s, statement: %s", Arrays.toString(keys), Arrays.toString(availableParameters), this.sql));
        }
        return this;
    }

    public ExpandedStatement expand() {
        return this.expand(Collections.emptyMap());
    }

    public ExpandedStatement expand(Consumer<Map<String, Object>> mapBuilder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        mapBuilder.accept(map);
        map.forEach((key, value) -> {
            if (value != null && !(value instanceof Serializable)) {
                throw new RuntimeException(String.format("%s of type %s is not serializable", key, value.getClass()));
            }
        });
        return this.expand(map);
    }

    public ExpandedStatement expand(Map<String, Object> parameters) {
        Object[] params = new Object[this.mappings.size()];
        for (Map.Entry<String, Integer> entry : this.mappings) {
            Object value = parameters.getOrDefault(entry.getKey(), NOT_FOUND_MARKER);
            if (value == NOT_FOUND_MARKER) {
                throw new IllegalArgumentException(String.format("Value for named parameter '%s' is missing", entry.getKey()));
            }
            params[entry.getValue().intValue()] = value;
        }
        return new ExpandedStatement(this.sql, params);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sql", (Object)this.sql).add("mappings", this.mappings).toString();
    }

    public static Statement statement(String sql, Object ... values) {
        if (sql == null) {
            return null;
        }
        String sqlFormatted = String.format(sql, values);
        Matcher m = DEFAULT_PATTERN.matcher(sqlFormatted);
        int idx = 0;
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<String, Integer>> mappings = new ArrayList<Map.Entry<String, Integer>>();
        while (m.find()) {
            m.appendReplacement(sb, "${pre}?");
            mappings.add(new AbstractMap.SimpleImmutableEntry<String, Integer>(m.group("name"), idx));
            ++idx;
        }
        m.appendTail(sb);
        return new Statement(sb.toString(), mappings);
    }

    public static class ExpandedStatement {
        private final String sql;
        private final Object[] parameters;
        private final Tracer tracer;
        private final SpanContext spanContext;

        private ExpandedStatement(String sql, Object[] parameters, Tracer tracer, SpanContext spanContext) {
            this.sql = sql;
            this.parameters = parameters;
            this.tracer = tracer;
            this.spanContext = spanContext;
        }

        private ExpandedStatement(String sql, Object[] parameters) {
            this(sql, parameters, null, null);
        }

        public String getSql() {
            return this.sql;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public JsonArray getParametersAsJson() {
            return new JsonArray(Arrays.asList(this.parameters));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sql", (Object)this.sql).add("parameters", (Object)this.parameters).toString();
        }

        public ExpandedStatement trace(Tracer tracer, SpanContext spanContext) {
            return new ExpandedStatement(this.sql, this.parameters, tracer, spanContext);
        }

        private <T> Future<T> run(Operation<T> operation) {
            Promise promise = Promise.promise();
            operation.run(this.sql, this.getParametersAsJson(), (Handler<AsyncResult<T>>)promise);
            return promise.future();
        }

        public Span startSqlSpan() {
            if (this.tracer == null || this.spanContext == null) {
                return null;
            }
            return SQL.startSqlSpan(this.tracer, this.spanContext, "execute SQL", builder -> builder.withTag(Tags.DB_STATEMENT.getKey(), this.sql));
        }

        public Future<ResultSet> query(SQLOperations connection) {
            Span sqlSpan = this.startSqlSpan();
            return SQL.finishSpan(this.run((arg_0, arg_1, arg_2) -> ((SQLOperations)connection).queryWithParams(arg_0, arg_1, arg_2)), sqlSpan, (r, log) -> log.put("rows", r.getNumRows()));
        }

        public Future<UpdateResult> update(SQLOperations connection) {
            Span sqlSpan = this.startSqlSpan();
            return SQL.finishSpan(this.run((arg_0, arg_1, arg_2) -> ((SQLOperations)connection).updateWithParams(arg_0, arg_1, arg_2)), sqlSpan, (r, log) -> log.put("rows", r.getUpdated()));
        }

        @FunctionalInterface
        private static interface Operation<T> {
            public void run(String var1, JsonArray var2, Handler<AsyncResult<T>> var3);
        }
    }
}

