/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store;

import com.google.common.base.Throwables;
import com.google.common.net.UrlEscapers;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.hono.service.base.jdbc.store.DuplicateKeyException;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQL {
    public static final String DIALECT_POSTGRESQL = "postgresql";
    public static final String DIALECT_H2 = "h2";
    private static final Logger log = LoggerFactory.getLogger(SQL.class);

    private SQL() {
    }

    public static <T> Future<T> translateException(Throwable e) {
        SQLException sqlError = SQL.causeOf(e, SQLException.class).orElse(null);
        if (sqlError == null) {
            return Future.failedFuture((Throwable)e);
        }
        log.debug("SQL Error: {}: {}", (Object)sqlError.getSQLState(), (Object)sqlError.getMessage());
        String code = sqlError.getSQLState();
        if (code == null) {
            return Future.failedFuture((Throwable)e);
        }
        switch (code) {
            case "23000": 
            case "23505": {
                return Future.failedFuture((Throwable)new DuplicateKeyException(e));
            }
        }
        return Future.failedFuture((Throwable)e);
    }

    public static Future<SQLConnection> setAutoCommit(Tracer tracer, SpanContext context, SQLConnection connection, boolean state) {
        Span span = SQL.startSqlSpan(tracer, context, "set autocommit", builder -> builder.withTag("db.autocommit", state));
        Promise promise = Promise.promise();
        connection.setAutoCommit(state, (Handler)promise);
        return SQL.finishSpan(promise.future().map((Object)connection), span, null);
    }

    public static Future<SQLConnection> commit(Tracer tracer, SpanContext context, SQLConnection connection) {
        Span span = SQL.startSqlSpan(tracer, context, "commit", null);
        Promise promise = Promise.promise();
        connection.commit((Handler)promise);
        return SQL.finishSpan(promise.future().map((Object)connection), span, null);
    }

    public static Future<SQLConnection> rollback(Tracer tracer, SpanContext context, SQLConnection connection) {
        Span span = SQL.startSqlSpan(tracer, context, "rollback", null);
        Promise promise = Promise.promise();
        connection.rollback((Handler)promise);
        return SQL.finishSpan(promise.future().map((Object)connection), span, null);
    }

    public static Span startSqlSpan(Tracer tracer, SpanContext context, String operationName, Consumer<Tracer.SpanBuilder> customizer) {
        if (tracer == null || context == null) {
            return null;
        }
        Tracer.SpanBuilder builder = TracingHelper.buildChildSpan((Tracer)tracer, (SpanContext)context, (String)operationName, (String)SQL.class.getSimpleName()).withTag(Tags.DB_TYPE.getKey(), "sql");
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.start();
    }

    public static <T> Future<T> finishSpan(Future<T> future, Span span, BiConsumer<T, Map<String, Object>> extractor) {
        if (span == null) {
            return future;
        }
        return future.onComplete(result -> {
            if (result.succeeded()) {
                SQL.traceSuccess(result.result(), span, extractor);
            } else {
                SQL.traceError(result.cause(), span);
            }
        });
    }

    private static <T> void traceSuccess(T result, Span span, BiConsumer<T, Map<String, Object>> extractor) {
        HashMap<String, String> log = new HashMap<String, String>();
        log.put("event", "success");
        if (extractor != null) {
            extractor.accept(result, log);
        }
        span.log(log);
        span.finish();
    }

    private static void traceError(Throwable e, Span span) {
        span.log(Map.of("event", "error", "error.kind", e.getClass().getName(), "error.object", e, "message", e.getMessage(), "stack", Throwables.getStackTraceAsString((Throwable)e)));
        Tags.ERROR.set(span, Boolean.valueOf(true));
        span.finish();
    }

    public static String getDatabaseDialect(String url) {
        URI uri = URI.create(UrlEscapers.urlPathSegmentEscaper().escape(url));
        String scheme = uri.getScheme();
        if (!"jdbc".equals(scheme)) {
            throw new IllegalArgumentException("URL is not a JDBC url: " + url);
        }
        URI subUri = URI.create(UrlEscapers.urlPathSegmentEscaper().escape(uri.getSchemeSpecificPart()));
        return subUri.getScheme();
    }

    public static boolean isSupportedDatabaseDialect(String databaseDialect) {
        return List.of(DIALECT_H2, DIALECT_POSTGRESQL).contains(databaseDialect);
    }

    public static <T extends Throwable> Optional<T> causeOf(Throwable e, Class<T> clazz) {
        if (e == null) {
            return Optional.empty();
        }
        return Throwables.getCausalChain((Throwable)e).stream().filter(clazz::isInstance).findFirst().map(clazz::cast);
    }

    public static <T extends Throwable> boolean hasCauseOf(Throwable e, Class<T> clazz) {
        return SQL.causeOf(e, clazz).isPresent();
    }

    public static <T> Future<T> runTransactionally(SQLClient client, Tracer tracer, SpanContext context, BiFunction<SQLConnection, SpanContext, Future<T>> function) {
        Span span = SQL.startSqlSpan(tracer, context, "run transactionally", builder -> {});
        Promise promise = Promise.promise();
        client.getConnection((Handler)promise);
        return promise.future().onSuccess(x -> {
            HashMap<String, String> log = new HashMap<String, String>();
            log.put("event", "success");
            log.put("message", "connection opened");
            span.log(log);
        }).flatMap(connection -> SQL.setAutoCommit(tracer, span.context(), connection, false).flatMap(y -> ((Future)function.apply((SQLConnection)connection, span.context())).compose(v -> SQL.commit(tracer, span.context(), connection).map(v), x -> SQL.rollback(tracer, span.context(), connection).flatMap(unused -> Future.failedFuture((Throwable)x)))).onComplete(x -> connection.close())).onComplete(x -> span.finish());
    }
}

