/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store;

import com.google.common.collect.ImmutableMap;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.base.jdbc.store.OptimisticLockingException;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.tracing.TracingHelper;

public abstract class AbstractStore
implements HealthCheckProvider,
AutoCloseable {
    private static final String DEFAULT_CHECK_SQL = "SELECT 1";
    private final SQLClient client;
    private final Tracer tracer;
    private final Statement.ExpandedStatement checkSql;

    public AbstractStore(SQLClient client, Tracer tracer, Optional<Statement> checkSql) {
        this.client = Objects.requireNonNull(client);
        this.tracer = Objects.requireNonNull(tracer);
        this.checkSql = checkSql.orElseGet(() -> Statement.statement(DEFAULT_CHECK_SQL, new Object[0])).expand();
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("sql", Duration.ofSeconds(10L).toMillis(), p -> this.checkSql.query((SQLOperations)this.client).onComplete(ar -> {
            if (ar.succeeded()) {
                p.tryComplete((Object)Status.OK());
            } else {
                p.tryFail(ar.cause());
            }
        }));
    }

    protected Future<UpdateResult> checkOptimisticLock(Future<UpdateResult> result, Span span, Optional<String> resourceVersion, Function<Span, Future<ResultSet>> reader) {
        if (resourceVersion.isEmpty()) {
            return result;
        }
        return result.flatMap(r -> {
            span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"check update result").put((Object)"update_count", (Object)r.getUpdated()).build());
            if (r.getUpdated() != 0) {
                return Future.succeededFuture((Object)r);
            }
            Span readSpan = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)span.context(), (String)"check optimistic lock", (String)this.getClass().getSimpleName()).withTag("resource_version", (String)resourceVersion.get()).start();
            Future f = ((Future)reader.apply(readSpan)).flatMap(readResult -> {
                span.log(Map.of("event", "check read result", "read_count", readResult.getNumRows()));
                if (readResult.getNumRows() <= 0) {
                    return Future.succeededFuture((Object)r);
                }
                return Future.failedFuture((Throwable)new OptimisticLockingException());
            });
            return f.onComplete(x -> readSpan.finish());
        });
    }
}

