/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.model;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceDto;

public class JdbcBasedDeviceDto
extends DeviceDto {
    public static JdbcBasedDeviceDto forCreation(DeviceKey deviceKey, Device device, String version) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(device);
        Objects.requireNonNull(version);
        return (JdbcBasedDeviceDto)DeviceDto.forCreation(JdbcBasedDeviceDto::new, (String)deviceKey.getTenantId(), (String)deviceKey.getDeviceId(), (Device)device, (String)version);
    }

    public static JdbcBasedDeviceDto forRead(String tenantId, String deviceId, JsonObject recordJson) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(recordJson);
        Device device = (Device)Json.decodeValue((String)recordJson.getString("data"), Device.class);
        return (JdbcBasedDeviceDto)DeviceDto.forRead(JdbcBasedDeviceDto::new, (String)tenantId, (String)deviceId, (Device)device, (Boolean)recordJson.getBoolean("auto_provisioned"), (Boolean)recordJson.getBoolean("auto_provisioning_notification_sent"), (Instant)recordJson.getInstant("created"), (Instant)recordJson.getInstant("updated_on"), (String)recordJson.getString("version"));
    }

    public static JdbcBasedDeviceDto forUpdate(DeviceKey deviceKey, Device device, String version) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(device);
        Objects.requireNonNull(version);
        return (JdbcBasedDeviceDto)DeviceDto.forUpdate(JdbcBasedDeviceDto::new, (String)deviceKey.getTenantId(), (String)deviceKey.getDeviceId(), (Device)device, (String)version);
    }

    public String getDeviceJson() {
        return Json.encode((Object)this.getData());
    }
}

