/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.base.jdbc.store.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.base.jdbc.store.EntityNotFoundException;
import org.eclipse.hono.service.base.jdbc.store.OptimisticLockingException;
import org.eclipse.hono.service.base.jdbc.store.SQL;
import org.eclipse.hono.service.base.jdbc.store.Statement;
import org.eclipse.hono.service.base.jdbc.store.StatementConfiguration;
import org.eclipse.hono.service.base.jdbc.store.device.AbstractDeviceStore;
import org.eclipse.hono.service.base.jdbc.store.device.CredentialsReadResult;
import org.eclipse.hono.service.base.jdbc.store.device.DeviceReadResult;
import org.eclipse.hono.service.base.jdbc.store.model.JdbcBasedDeviceDto;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.credentials.CredentialsDto;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableManagementStore
extends AbstractDeviceStore {
    private static final Logger log = LoggerFactory.getLogger(TableManagementStore.class);
    private final Statement createStatement;
    private final Statement createMemberOfStatement;
    private final Statement deleteAllMemberOfStatement;
    private final Statement updateRegistrationVersionedStatement;
    private final Statement deleteStatement;
    private final Statement deleteVersionedStatement;
    private final Statement dropTenantStatement;
    private final Statement readForUpdateStatement;
    private final Statement readCredentialsStatement;
    private final Statement insertCredentialEntryStatement;
    private final Statement deleteAllCredentialsStatement;
    private final Statement updateDeviceVersionStatement;

    public TableManagementStore(SQLClient client, Tracer tracer, StatementConfiguration cfg) {
        super(client, tracer, cfg);
        cfg.dump(log);
        this.createStatement = cfg.getRequiredStatement("create").validateParameters("tenant_id", "device_id", "version", "data", "created", "auto_provisioned");
        this.createMemberOfStatement = cfg.getRequiredStatement("createMemberOf").validateParameters("tenant_id", "device_id", "group_id");
        this.deleteAllMemberOfStatement = cfg.getRequiredStatement("deleteAllMemberOf").validateParameters("tenant_id", "device_id");
        this.updateRegistrationVersionedStatement = cfg.getRequiredStatement("updateRegistrationVersioned").validateParameters("tenant_id", "device_id", "next_version", "data", "expected_version", "updated_on", "auto_provisioning_notification_sent");
        this.deleteStatement = cfg.getRequiredStatement("delete").validateParameters("tenant_id", "device_id");
        this.deleteVersionedStatement = cfg.getRequiredStatement("deleteVersioned").validateParameters("tenant_id", "device_id", "expected_version");
        this.dropTenantStatement = cfg.getRequiredStatement("dropTenant").validateParameters("tenant_id");
        this.readForUpdateStatement = cfg.getRequiredStatement("readForUpdate").validateParameters("tenant_id", "device_id");
        this.readCredentialsStatement = cfg.getRequiredStatement("readCredentials").validateParameters("tenant_id", "device_id");
        this.insertCredentialEntryStatement = cfg.getRequiredStatement("insertCredentialEntry").validateParameters("tenant_id", "device_id", "type", "auth_id", "data");
        this.deleteAllCredentialsStatement = cfg.getRequiredStatement("deleteAllCredentials").validateParameters("tenant_id", "device_id");
        this.updateDeviceVersionStatement = cfg.getRequiredStatement("updateDeviceVersion").validateParameters("tenant_id", "device_id", "next_version", "expected_version");
    }

    protected Future<ResultSet> readDeviceForUpdate(SQLConnection connection, DeviceKey key, SpanContext span) {
        return this.read((SQLOperations)connection, key, Optional.empty(), this.readForUpdateStatement, span);
    }

    public Future<Versioned<Void>> createDevice(DeviceKey key, Device device, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"create device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forCreation(key, device, DeviceRegistryUtils.getUniqueIdentifier());
        return SQL.runTransactionally(this.client, this.tracer, span.context(), (connection, context) -> {
            Statement.ExpandedStatement expanded = this.createStatement.expand(params -> {
                params.put("tenant_id", deviceDto.getTenantId());
                params.put("device_id", deviceDto.getDeviceId());
                params.put("version", deviceDto.getVersion());
                params.put("data", deviceDto.getDeviceJson());
                params.put("created", Timestamp.from(deviceDto.getCreationTime()));
                params.put("auto_provisioned", deviceDto.isAutoProvisioned());
            });
            log.debug("createDevice - statement: {}", (Object)expanded);
            return expanded.trace(this.tracer, (SpanContext)context).update((SQLOperations)this.client).recover(SQL::translateException).compose(x -> this.createGroups((SQLConnection)connection, key, (Set<String>)new HashSet<String>(device.getMemberOf()), (SpanContext)context));
        }).map((Object)new Versioned(deviceDto.getVersion(), null)).onComplete(x -> span.finish());
    }

    private Future<Void> createGroups(SQLConnection connection, DeviceKey key, Set<String> memberOf, SpanContext context) {
        return CompositeFuture.all(memberOf.stream().map(groupId -> {
            Statement.ExpandedStatement expanded = this.createMemberOfStatement.expand(params -> {
                params.put("tenant_id", key.getTenantId());
                params.put("device_id", key.getDeviceId());
                params.put("group_id", groupId);
            });
            log.debug("addToGroup - statement: {}", (Object)expanded);
            return expanded.trace(this.tracer, context).update((SQLOperations)connection).recover(SQL::translateException);
        }).collect(Collectors.toList())).mapEmpty();
    }

    private Future<Void> deleteGroups(SQLConnection connection, DeviceKey key, SpanContext context) {
        Statement.ExpandedStatement expanded = this.deleteAllMemberOfStatement.expand(params -> {
            params.put("tenant_id", key.getTenantId());
            params.put("device_id", key.getDeviceId());
        });
        log.debug("deleteGroups - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, context).update((SQLOperations)connection).recover(SQL::translateException).mapEmpty();
    }

    protected Future<UpdateResult> updateJsonField(DeviceKey key, Statement statement, String jsonValue, Optional<String> resourceVersion, String nextVersion, Span span) {
        Statement.ExpandedStatement expanded = statement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
            map.put("next_version", nextVersion);
            map.put("data", jsonValue);
            resourceVersion.ifPresent(version -> map.put("expected_version", version));
        });
        log.debug("update - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return this.checkOptimisticLock(result, span, resourceVersion, checkSpan -> this.readDevice((SQLOperations)this.client, key, (Span)checkSpan));
    }

    public Future<Versioned<Void>> updateDevice(DeviceKey key, Device device, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"update device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        resourceVersion.ifPresent(version -> span.setTag("version", version));
        Set memberOf = Optional.ofNullable(device.getMemberOf()).map(HashSet::new).orElse(Collections.emptySet());
        JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forUpdate(key, device, DeviceRegistryUtils.getUniqueIdentifier());
        return SQL.runTransactionally(this.client, this.tracer, span.context(), (connection, context) -> this.readDeviceForUpdate((SQLConnection)connection, key, (SpanContext)context).compose(result -> TableManagementStore.extractVersionForUpdate(result, resourceVersion)).compose(version -> this.deleteGroups((SQLConnection)connection, key, (SpanContext)context).map(version)).compose(version -> this.createGroups((SQLConnection)connection, key, memberOf, (SpanContext)context).map(version)).compose(version -> this.updateRegistrationVersionedStatement.expand(map -> {
            map.put("tenant_id", deviceDto.getTenantId());
            map.put("device_id", deviceDto.getDeviceId());
            map.put("data", deviceDto.getDeviceJson());
            map.put("expected_version", version);
            map.put("next_version", deviceDto.getVersion());
            map.put("updated_on", Timestamp.from(deviceDto.getUpdatedOn()));
            map.put("auto_provisioning_notification_sent", deviceDto.isAutoProvisioningNotificationSent());
        }).trace(this.tracer, span.context()).update((SQLOperations)connection).compose(TableManagementStore::checkUpdateOutcome).map(version))).map(x -> new Versioned(deviceDto.getVersion(), null)).onComplete(x -> span.finish());
    }

    public Future<Optional<DeviceReadResult>> readDevice(DeviceKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"read device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        return this.readDevice((SQLOperations)this.client, key, span).flatMap(r -> {
            List entries = r.getRows(true);
            switch (entries.size()) {
                case 0: {
                    return Future.succeededFuture(Optional.empty());
                }
                case 1: {
                    JsonObject entry = (JsonObject)entries.get(0);
                    JdbcBasedDeviceDto deviceDto = JdbcBasedDeviceDto.forRead(key.getTenantId(), key.getDeviceId(), entry);
                    return Future.succeededFuture(Optional.of(new DeviceReadResult(deviceDto.getDeviceWithStatus(), Optional.of(deviceDto.getVersion()))));
                }
            }
            return Future.failedFuture((Throwable)new IllegalStateException("Found multiple entries for a single device"));
        }).onComplete(x -> span.finish());
    }

    public Future<UpdateResult> deleteDevice(DeviceKey key, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"delete device", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        resourceVersion.ifPresent(version -> span.setTag("version", version));
        Statement statement = resourceVersion.isPresent() ? this.deleteVersionedStatement : this.deleteStatement;
        Statement.ExpandedStatement expanded = statement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
            resourceVersion.ifPresent(version -> map.put("expected_version", version));
        });
        log.debug("delete - statement: {}", (Object)expanded);
        Future<UpdateResult> result = expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client);
        return this.checkOptimisticLock(result, span, resourceVersion, checkSpan -> this.readDevice((SQLOperations)this.client, key, (Span)checkSpan)).onComplete(x -> span.finish());
    }

    public Future<UpdateResult> dropTenant(String tenantId, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"drop tenant", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        Statement.ExpandedStatement expanded = this.dropTenantStatement.expand(params -> params.put("tenant_id", tenantId));
        log.debug("delete - statement: {}", (Object)expanded);
        return expanded.trace(this.tracer, span.context()).update((SQLOperations)this.client).onComplete(x -> span.finish());
    }

    public Future<Versioned<Boolean>> setCredentials(DeviceKey key, List<CommonCredential> credentials, Optional<String> resourceVersion, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"set credentials", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).withTag("num_credentials", (Number)credentials.size()).start();
        resourceVersion.ifPresent(version -> span.setTag("version", version));
        String nextVersion = UUID.randomUUID().toString();
        return SQL.runTransactionally(this.client, this.tracer, span.context(), (connection, context) -> this.readDeviceForUpdate((SQLConnection)connection, key, (SpanContext)context).compose(result -> TableManagementStore.extractVersionForUpdate(result, resourceVersion)).compose(version -> Future.succeededFuture().compose(x -> {
            Promise result = Promise.promise();
            CredentialsDto updatedCredentialsDto = CredentialsDto.forUpdate((String)key.getTenantId(), (String)key.getDeviceId(), (List)credentials, (String)nextVersion);
            if (updatedCredentialsDto.requiresMerging()) {
                this.getCredentialsDto(key, (SQLConnection)connection, span).map(arg_0 -> ((CredentialsDto)updatedCredentialsDto).merge(arg_0)).onComplete((Handler)result);
            } else {
                result.complete((Object)updatedCredentialsDto);
            }
            return result.future();
        }).compose(updatedCredentials -> this.deleteAllCredentialsStatement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
        }).trace(this.tracer, span.context()).update((SQLOperations)connection).map(updatedCredentials)).compose(updatedCredentials -> {
            updatedCredentials.createMissingSecretIds();
            return CompositeFuture.all(updatedCredentials.getData().stream().map(JsonObject::mapFrom).filter(c -> c.containsKey("type") && c.containsKey("auth-id")).map(c -> this.insertCredentialEntryStatement.expand(map -> {
                map.put("tenant_id", key.getTenantId());
                map.put("device_id", key.getDeviceId());
                map.put("type", c.getString("type"));
                map.put("auth_id", c.getString("auth-id"));
                map.put("data", c.toString());
            }).trace(this.tracer, span.context()).update((SQLOperations)connection)).collect(Collectors.toList())).mapEmpty();
        }).compose(x -> this.updateDeviceVersionStatement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
            map.put("expected_version", version);
            map.put("next_version", nextVersion);
        }).trace(this.tracer, span.context()).update((SQLOperations)connection).compose(TableManagementStore::checkUpdateOutcome)).map((Object)true))).recover(err -> this.recoverNotFound(span, (Throwable)err, () -> false)).map(ok -> new Versioned(nextVersion, ok)).onComplete(x -> span.finish());
    }

    private Future<CredentialsDto> getCredentialsDto(DeviceKey key, SQLConnection connection, Span span) {
        return this.readCredentialsStatement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
        }).trace(this.tracer, span.context()).query((SQLOperations)connection).map(this::parseCredentials).map(existingCredentials -> CredentialsDto.forRead((String)key.getTenantId(), (String)key.getDeviceId(), (List)existingCredentials, null, null, null));
    }

    private <T> Future<T> recoverNotFound(Span span, Throwable err, Supplier<T> orProvider) {
        log.debug("Failed to update", err);
        if (SQL.hasCauseOf(err, EntityNotFoundException.class)) {
            TracingHelper.logError((Span)span, (String)"Entity not found");
            return Future.succeededFuture(orProvider.get());
        }
        return Future.failedFuture((Throwable)err);
    }

    private static Future<Object> checkUpdateOutcome(UpdateResult updateResult) {
        if (updateResult.getUpdated() < 0) {
            log.debug("Optimistic lock broke");
            return Future.failedFuture((Throwable)new OptimisticLockingException());
        }
        return Future.succeededFuture();
    }

    private static Future<String> extractVersionForUpdate(ResultSet device, Optional<String> resourceVersion) {
        Optional<String> version = device.getRows(true).stream().map(o -> o.getString("version")).findAny();
        if (version.isEmpty()) {
            log.debug("No version or no row found -> entity not found");
            return Future.failedFuture((Throwable)new EntityNotFoundException());
        }
        String currentVersion = version.get();
        return resourceVersion.map(expected -> {
            if (expected.equals(currentVersion)) {
                return Future.succeededFuture((Object)currentVersion);
            }
            return Future.failedFuture((Throwable)new OptimisticLockingException());
        }).orElseGet(() -> Future.succeededFuture((Object)currentVersion));
    }

    public Future<Optional<CredentialsReadResult>> getCredentials(DeviceKey key, SpanContext spanContext) {
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"get credentials", (String)this.getClass().getSimpleName()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)key.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)key.getDeviceId()).start();
        Statement.ExpandedStatement expanded = this.readCredentialsStatement.expand(map -> {
            map.put("tenant_id", key.getTenantId());
            map.put("device_id", key.getDeviceId());
        });
        Promise promise = Promise.promise();
        this.client.getConnection((Handler)promise);
        return promise.future().compose(connection -> this.readDevice((SQLOperations)connection, key, span).compose(result -> TableManagementStore.extractVersionForUpdate(result, Optional.empty())).compose(version -> expanded.trace(this.tracer, span.context()).query((SQLOperations)connection).compose(r -> {
            span.log(Map.of("event", "read result", "rows", r.getNumRows()));
            List<CommonCredential> credentials = this.parseCredentials((ResultSet)r);
            log.debug("Credentials: {}", credentials);
            return Future.succeededFuture(Optional.of(new CredentialsReadResult(key.getDeviceId(), credentials, Optional.ofNullable(version))));
        })).onComplete(x -> connection.close())).recover(err -> this.recoverNotFound(span, (Throwable)err, Optional::empty)).onComplete(x -> span.finish());
    }

    private List<CommonCredential> parseCredentials(ResultSet result) {
        List entries = result.getRows(true);
        return entries.stream().map(o -> o.getString("data")).map(s -> (CommonCredential)Json.decodeValue((String)s, CommonCredential.class)).collect(Collectors.toList());
    }
}

