/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication.app;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import org.eclipse.hono.authentication.AuthenticationEndpoint;
import org.eclipse.hono.authentication.AuthenticationServerMetrics;
import org.eclipse.hono.authentication.MicrometerBasedAuthenticationServerMetrics;
import org.eclipse.hono.authentication.SimpleAuthenticationServer;
import org.eclipse.hono.authentication.file.FileBasedAuthenticationService;
import org.eclipse.hono.authentication.file.FileBasedAuthenticationServiceConfigProperties;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.AbstractServiceApplication;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.auth.AuthTokenFactory;
import org.eclipse.hono.service.auth.AuthTokenValidator;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.service.auth.EventBusAuthenticationService;
import org.eclipse.hono.service.auth.HonoSaslAuthenticatorFactory;
import org.eclipse.hono.service.auth.JjwtBasedAuthTokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Application
extends AbstractServiceApplication {
    private static final String COMPONENT_NAME = "Hono Authentication Server";
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    @Inject
    FileBasedAuthenticationServiceConfigProperties serviceConfig;
    @Inject
    AuthTokenFactory authTokenFactory;
    @Inject
    ServiceConfigProperties amqpProps;

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    protected void doStart() {
        LOG.info("deploying {} ...", (Object)this.getComponentName());
        HashMap deploymentResult = new HashMap();
        FileBasedAuthenticationService authenticationService = this.authenticationService();
        Future authServiceDeploymentTracker = this.vertx.deployVerticle((Verticle)authenticationService).onSuccess(ok -> {
            LOG.info("successfully deployed authentication service verticle");
            deploymentResult.put("authentication service verticle", "successfully deployed");
        });
        Future amqpServerDeploymentTracker = this.vertx.deployVerticle(() -> this.simpleAuthenticationServer((AuthenticationService)authenticationService), new DeploymentOptions().setInstances(this.appConfig.getMaxInstances())).onSuccess(ok -> {
            LOG.info("successfully deployed AMQP server verticle(s)");
            deploymentResult.put("AMQP server verticle(s)", "successfully deployed");
        });
        Future.all((Future)authServiceDeploymentTracker, (Future)amqpServerDeploymentTracker).map(deploymentResult).onComplete((Handler)this.deploymentCheck);
    }

    FileBasedAuthenticationService authenticationService() {
        LOG.info("creating {} instance", (Object)FileBasedAuthenticationService.class.getName());
        FileBasedAuthenticationService service = new FileBasedAuthenticationService();
        service.setConfig((Object)this.serviceConfig);
        service.setTokenFactory(this.authTokenFactory);
        return service;
    }

    AuthTokenValidator tokenValidator() {
        if (!this.serviceConfig.getValidation().isAppropriateForValidating() && this.amqpProps.getCertPath() != null) {
            this.serviceConfig.getValidation().setCertPath(this.amqpProps.getCertPath());
        }
        return new JjwtBasedAuthTokenValidator(this.vertx, this.serviceConfig.getValidation());
    }

    ProtonSaslAuthenticatorFactory authenticatorFactory(AuthenticationService authService, AuthenticationServerMetrics metrics) {
        EventBusAuthenticationService eventBusAuthService = new EventBusAuthenticationService(this.vertx, this.tokenValidator(), authService.getSupportedSaslMechanisms());
        return new HonoSaslAuthenticatorFactory((AuthenticationService)eventBusAuthService, arg_0 -> ((AuthenticationServerMetrics)metrics).reportConnectionAttempt(arg_0));
    }

    SimpleAuthenticationServer simpleAuthenticationServer(AuthenticationService authService) {
        LOG.info("creating {} instance", (Object)SimpleAuthenticationServer.class.getName());
        MicrometerBasedAuthenticationServerMetrics metrics = new MicrometerBasedAuthenticationServerMetrics(this.meterRegistry);
        SimpleAuthenticationServer server = new SimpleAuthenticationServer();
        server.setConfig((Object)this.amqpProps);
        server.setSaslAuthenticatorFactory(this.authenticatorFactory(authService, (AuthenticationServerMetrics)metrics));
        server.addEndpoint((AmqpEndpoint)new AuthenticationEndpoint(this.vertx));
        server.setMetrics((AuthenticationServerMetrics)metrics);
        return server;
    }
}

