/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Source;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.amqp.AmqpServiceBase;
import org.eclipse.hono.service.auth.AddressAuthzHelper;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class SimpleAuthenticationServer
extends AmqpServiceBase<ServiceConfigProperties> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAuthenticationServer.class);

    @Autowired
    public void setConfig(ServiceConfigProperties configuration) {
        this.setSpecificConfig(configuration);
    }

    protected String getServiceName() {
        return "hono-auth";
    }

    protected void setRemoteConnectionOpenHandler(ProtonConnection connection) {
        connection.sessionOpenHandler(remoteOpenSession -> this.handleSessionOpen(connection, (ProtonSession)remoteOpenSession));
        connection.senderOpenHandler(remoteOpenSender -> this.handleSenderOpen(connection, (ProtonSender)remoteOpenSender));
        connection.disconnectHandler(con -> {
            con.close();
            con.disconnect();
        });
        connection.closeHandler(remoteClose -> {
            connection.close();
            connection.disconnect();
        });
        connection.openHandler(remoteOpen -> {
            if (remoteOpen.failed()) {
                LOG.debug("ignoring peer's open frame containing error", remoteOpen.cause());
            } else {
                this.processRemoteOpen((ProtonConnection)remoteOpen.result());
            }
        });
    }

    protected void processRemoteOpen(ProtonConnection connection) {
        if (AddressAuthzHelper.isAddressAuthzCapabilitySet((ProtonConnection)connection)) {
            LOG.debug("client [container: {}] requests transfer of authenticated user's authorities in open frame", (Object)connection.getRemoteContainer());
            AddressAuthzHelper.processAddressAuthzCapability((ProtonConnection)connection);
        }
        connection.open();
        this.vertx.setTimer(5000L, closeCon -> {
            if (!connection.isDisconnected()) {
                LOG.debug("connection with client [{}] timed out after 5 seconds, closing connection", (Object)connection.getRemoteContainer());
                connection.setCondition(ProtonHelper.condition((Symbol)Constants.AMQP_ERROR_INACTIVITY, (String)"client must retrieve token within 5 secs after opening connection")).close();
            }
        });
    }

    protected void handleReceiverOpen(ProtonConnection con, ProtonReceiver receiver) {
        receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_ALLOWED, (String)"cannot write to node"));
        receiver.close();
    }

    protected void handleSenderOpen(ProtonConnection con, ProtonSender sender) {
        Source remoteSource = sender.getRemoteSource();
        LOG.debug("client [{}] wants to open a link for receiving messages [address: {}]", (Object)con.getRemoteContainer(), (Object)remoteSource);
        ResourceIdentifier targetResource = this.getResourceIdentifier(remoteSource.getAddress());
        AmqpEndpoint endpoint = this.getEndpoint(targetResource);
        if (endpoint == null) {
            LOG.debug("no endpoint registered for node [{}]", (Object)targetResource);
            con.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)"no such node")).close();
        } else {
            HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
            if ("ANONYMOUS".equals(user.getName())) {
                con.setCondition(ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)"client must authenticate using SASL")).close();
            } else {
                Constants.copyProperties((ProtonConnection)con, (ProtonLink)sender);
                sender.setSource(sender.getRemoteSource());
                endpoint.onLinkAttach(con, sender, targetResource);
            }
        }
    }
}

