/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import java.util.List;
import java.util.Objects;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class AuthenticationServerConfigProperties {
    private static final Resource DEFAULT_PERMISSIONS_RESOURCE = new ClassPathResource("permissions.json");
    private final SignatureSupportingConfigProperties signing = new SignatureSupportingConfigProperties();
    private Resource permissionsResource = DEFAULT_PERMISSIONS_RESOURCE;
    private List<String> supportedSaslMechanisms = List.of(AbstractHonoAuthenticationService.DEFAULT_SASL_MECHANISMS);

    public final SignatureSupportingConfigProperties getSigning() {
        return this.signing;
    }

    public final SignatureSupportingConfigProperties getValidation() {
        return this.signing;
    }

    public final Resource getPermissionsPath() {
        return this.permissionsResource;
    }

    public final void setPermissionsPath(Resource permissionsResource) {
        this.permissionsResource = Objects.requireNonNull(permissionsResource);
    }

    public final List<String> getSupportedSaslMechanisms() {
        return this.supportedSaslMechanisms;
    }

    public final void setSupportedSaslMechanisms(List<String> supportedSaslMechanisms) {
        if (Objects.requireNonNull(supportedSaslMechanisms).stream().noneMatch(AbstractHonoAuthenticationService::isCompatibleSaslMechanism)) {
            throw new IllegalArgumentException("invalid list of SASL mechanisms");
        }
        this.supportedSaslMechanisms = supportedSaslMechanisms;
    }
}

