/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.impl;

import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Source;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AmqpServiceBase;
import org.eclipse.hono.service.amqp.Endpoint;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public final class SimpleAuthenticationServer
extends AmqpServiceBase<ServiceConfigProperties> {
    @Autowired
    public void setConfig(ServiceConfigProperties configuration) {
        this.setSpecificConfig(configuration);
    }

    protected String getServiceName() {
        return "Hono-Auth";
    }

    protected void handleReceiverOpen(ProtonConnection con, ProtonReceiver receiver) {
        ((ProtonReceiver)receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_ALLOWED, (String)"cannot write to node"))).close();
    }

    protected void handleSenderOpen(ProtonConnection con, ProtonSender sender) {
        Source remoteSource = sender.getRemoteSource();
        this.LOG.debug("client [{}] wants to open a link for receiving messages [address: {}]", (Object)con.getRemoteContainer(), (Object)remoteSource);
        try {
            ResourceIdentifier targetResource = this.getResourceIdentifier(remoteSource.getAddress());
            Endpoint endpoint = this.getEndpoint(targetResource);
            if (endpoint == null) {
                this.LOG.debug("no endpoint registered for node [{}]", (Object)targetResource);
                con.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)"no such node")).close();
            } else {
                HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
                if ("ANONYMOUS".equals(user.getName())) {
                    con.setCondition(ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)"client must authenticate using SASL")).close();
                } else {
                    Constants.copyProperties((ProtonConnection)con, (ProtonLink)sender);
                    sender.setSource(sender.getRemoteSource());
                    endpoint.onLinkAttach(con, sender, targetResource);
                    this.vertx.setTimer(5000L, closeCon -> {
                        if (!con.isDisconnected()) {
                            this.LOG.debug("connection with client [{}] timed out after 5 seconds, closing connection", (Object)con.getRemoteContainer());
                            con.setCondition(ProtonHelper.condition((String)"hono: inactivity", (String)"client must retrieve token within 5 secs after opening connection")).close();
                        }
                    });
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.LOG.debug("client has provided invalid resource identifier as source address", (Throwable)e);
            con.setCondition(ProtonHelper.condition((Symbol)AmqpError.INVALID_FIELD, (String)"malformed source address")).close();
        }
    }
}

